/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.test.fixtures;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.hiero.base.crypto.Message;

public final class MessageDigestPool {
    private ArrayList<KnownDigest> messages;
    private int poolSize;
    private int messageSize;
    private AtomicInteger readPosition;
    private Random random;
    private MessageDigest digest;

    public MessageDigestPool(int poolSize, int messageSize) throws NoSuchAlgorithmException {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize");
        }
        if (messageSize < 1) {
            throw new IllegalArgumentException("messageSize");
        }
        this.poolSize = poolSize;
        this.messageSize = messageSize;
        this.messages = new ArrayList(poolSize);
        this.readPosition = new AtomicInteger(0);
        this.random = new Random();
        this.digest = MessageDigest.getInstance("SHA-384");
        this.init();
    }

    public Message next() {
        int nextIdx = this.readPosition.getAndIncrement();
        if (nextIdx >= this.messages.size()) {
            nextIdx = 0;
            this.readPosition.set(1);
        }
        return this.messages.get(nextIdx).provide();
    }

    public int size() {
        return this.messages.size();
    }

    public boolean isValid(Message message) {
        int index = this.messages.indexOf(new KnownDigest(this, null, message));
        if (index < 0) {
            return false;
        }
        KnownDigest kd = this.messages.get(index);
        return kd != null && kd.isValid(message.getHash().copyToByteArray());
    }

    public boolean isValid(Message message, byte[] hash) {
        int index = this.messages.indexOf(new KnownDigest(this, null, message));
        if (index < 0) {
            return false;
        }
        KnownDigest kd = this.messages.get(index);
        return kd != null && kd.isValid(hash);
    }

    private void init() {
        for (int i = 0; i < this.poolSize; ++i) {
            byte[] payload = new byte[this.messageSize];
            this.random.nextBytes(payload);
            this.digest.update(payload);
            byte[] hash = this.digest.digest();
            this.messages.add(new KnownDigest(this, hash, new Message(payload)));
        }
    }

    final class KnownDigest
    implements Comparable<KnownDigest> {
        private byte[] hash;
        private Message message;

        KnownDigest(MessageDigestPool this$0, byte[] hash, Message message) {
            this.hash = hash;
            this.message = message;
        }

        public byte[] getHash() {
            return this.hash;
        }

        public Message getMessage() {
            return this.message;
        }

        public boolean isValid(byte[] hash) {
            if (hash == null || hash.length != this.hash.length) {
                return false;
            }
            return Arrays.compare(this.hash, hash) == 0;
        }

        public Message provide() {
            this.message.setHash(null);
            return this.message;
        }

        public int hashCode() {
            return Objects.hash(this.message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KnownDigest)) {
                return false;
            }
            KnownDigest that = (KnownDigest)o;
            return this.message.equals((Object)that.message);
        }

        @Override
        public int compareTo(KnownDigest that) {
            if (this == that) {
                return 0;
            }
            if (that == null) {
                return 1;
            }
            return this.message.compareTo(that.message);
        }
    }
}

