/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.roster;

import com.swirlds.base.utility.ToStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import org.hiero.base.crypto.CryptoUtils;
import org.hiero.base.crypto.SerializablePublicKey;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.base.utility.NonCryptographicHashing;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.SerializableX509Certificate;

public class Address
implements SelfSerializable {
    private static final long CLASS_ID = 408980092978607982L;
    private static final int STRING_MAX_BYTES = 512;
    private int serialization = 6;
    private NodeId id;
    private String nickname;
    private String selfName;
    private long weight;
    private String hostnameInternal;
    private int portInternal;
    private String hostnameExternal;
    private int portExternal;
    private SerializablePublicKey sigPublicKey = null;
    private SerializablePublicKey encPublicKey;
    private SerializablePublicKey agreePublicKey = null;
    private SerializableX509Certificate sigCert = null;
    private SerializableX509Certificate agreeCert = null;
    private String memo;

    public Address() {
        this(NodeId.FIRST_NODE_ID, "", "", 1L, null, -1, null, -1, null, null, "");
    }

    public Address(@NonNull NodeId id, @NonNull String nickname, @NonNull String selfName, long weight, @Nullable String hostnameInternal, int portInternal, @Nullable String hostnameExternal, int portExternal, @Nullable SerializableX509Certificate sigCert, @Nullable SerializableX509Certificate agreeCert, @NonNull String memo) {
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.nickname = Objects.requireNonNull(nickname, "nickname must not be null");
        this.selfName = Objects.requireNonNull(selfName, "selfName must not be null");
        this.weight = weight;
        this.portInternal = portInternal;
        this.portExternal = portExternal;
        this.hostnameInternal = hostnameInternal;
        this.hostnameExternal = hostnameExternal;
        this.sigCert = sigCert == null ? null : this.checkCertificateEncoding(sigCert);
        this.agreeCert = agreeCert == null ? null : this.checkCertificateEncoding(agreeCert);
        this.memo = Objects.requireNonNull(memo, "memo must not be null");
    }

    public int getMinimumSupportedVersion() {
        return 5;
    }

    public int getVersion() {
        return this.serialization;
    }

    public long getClassId() {
        return 408980092978607982L;
    }

    public long getWeight() {
        return this.weight;
    }

    public boolean isZeroWeight() {
        return this.weight == 0L;
    }

    @NonNull
    public NodeId getNodeId() {
        return this.id;
    }

    @NonNull
    public String getNickname() {
        return this.nickname;
    }

    @NonNull
    public String getSelfName() {
        return this.selfName;
    }

    public int getListenPort() {
        return this.getPortInternal();
    }

    public int getPortInternal() {
        return this.portInternal;
    }

    public int getPortExternal() {
        return this.portExternal;
    }

    @Nullable
    public String getHostnameInternal() {
        return this.hostnameInternal;
    }

    @Nullable
    public String getHostnameExternal() {
        return this.hostnameExternal;
    }

    @Nullable
    public PublicKey getSigPublicKey() {
        if (this.sigCert != null) {
            return this.sigCert.getPublicKey();
        }
        return this.sigPublicKey == null ? null : this.sigPublicKey.getPublicKey();
    }

    @Deprecated(since="0.51.0", forRemoval=true)
    @Nullable
    public PublicKey getAgreePublicKey() {
        if (this.agreeCert != null) {
            return this.agreeCert.getPublicKey();
        }
        return this.agreePublicKey == null ? null : this.agreePublicKey.getPublicKey();
    }

    @Nullable
    public X509Certificate getSigCert() {
        return this.sigCert == null ? null : this.sigCert.getCertificate();
    }

    @Deprecated(since="0.51.0", forRemoval=true)
    @Nullable
    public X509Certificate getAgreeCert() {
        return this.agreeCert == null ? null : this.agreeCert.getCertificate();
    }

    @NonNull
    public String getMemo() {
        return this.memo;
    }

    @NonNull
    public Address copySetNodeId(@NonNull NodeId id) {
        Objects.requireNonNull(id, "id must not be null");
        Address a = this.copy();
        a.id = id;
        return a;
    }

    @NonNull
    public Address copySetWeight(long weight) {
        Address a = this.copy();
        a.weight = weight;
        return a;
    }

    @NonNull
    public Address copySetNickname(@NonNull String nickname) {
        Objects.requireNonNull(nickname, "nickname must not be null");
        Address a = this.copy();
        a.nickname = nickname;
        return a;
    }

    @NonNull
    public Address copySetSelfName(@NonNull String selfName) {
        Objects.requireNonNull(selfName, "selfName must not be null");
        Address a = this.copy();
        a.selfName = selfName;
        return a;
    }

    @NonNull
    public Address copySetPortInternal(int portInternal) {
        Address a = this.copy();
        a.portInternal = portInternal;
        return a;
    }

    @NonNull
    public Address copySetPortExternal(int portExternal) {
        Address a = this.copy();
        a.portExternal = portExternal;
        return a;
    }

    @NonNull
    public Address copySetHostnameInternal(@NonNull String hostnameInternal) {
        Objects.requireNonNull(hostnameInternal, "hostnameInternal must not be null");
        Address a = this.copy();
        a.hostnameInternal = hostnameInternal;
        return a;
    }

    @NonNull
    public Address copySetHostnameExternal(@NonNull String hostnameExternal) {
        Objects.requireNonNull(hostnameExternal, "hostnameExternal must not be null");
        Address a = this.copy();
        a.hostnameExternal = hostnameExternal;
        return a;
    }

    @NonNull
    public Address copySetSigCert(@Nullable X509Certificate sigCert) {
        Address a = this.copy();
        a.sigCert = sigCert == null ? null : this.checkCertificateEncoding(new SerializableX509Certificate(sigCert));
        return a;
    }

    @Deprecated(since="0.51.0", forRemoval=true)
    @NonNull
    public Address copySetAgreeCert(@Nullable X509Certificate agreeCert) {
        Address a = this.copy();
        a.agreeCert = agreeCert == null ? null : this.checkCertificateEncoding(new SerializableX509Certificate(agreeCert));
        return a;
    }

    @NonNull
    public Address copySetMemo(@NonNull String memo) {
        Objects.requireNonNull(memo, "memo must not be null");
        Address a = this.copy();
        a.memo = memo;
        return a;
    }

    public Address copy() {
        return new Address(this.id, this.nickname, this.selfName, this.weight, this.hostnameInternal, this.portInternal, this.hostnameExternal, this.portExternal, this.sigCert, this.agreeCert, this.memo);
    }

    public void serialize(SerializableDataOutputStream outStream) throws IOException {
        outStream.writeSerializable((SelfSerializable)this.id, false);
        outStream.writeNormalisedString(this.nickname);
        outStream.writeNormalisedString(this.selfName);
        outStream.writeLong(this.weight);
        outStream.writeNormalisedString(this.hostnameInternal);
        outStream.writeInt(this.portInternal);
        outStream.writeNormalisedString(this.hostnameExternal);
        outStream.writeInt(this.portExternal);
        if (this.serialization < 6) {
            outStream.writeSerializable((SelfSerializable)this.sigPublicKey, false);
            outStream.writeSerializable((SelfSerializable)this.encPublicKey, false);
            outStream.writeSerializable((SelfSerializable)this.agreePublicKey, false);
        } else {
            outStream.writeSerializable((SelfSerializable)this.sigCert, false);
            outStream.writeSerializable((SelfSerializable)this.agreeCert, false);
        }
        outStream.writeNormalisedString(this.memo);
    }

    public void deserialize(SerializableDataInputStream inStream, int version) throws IOException {
        this.serialization = version;
        this.id = (NodeId)inStream.readSerializable(false, NodeId::new);
        this.nickname = inStream.readNormalisedString(512);
        this.selfName = inStream.readNormalisedString(512);
        this.weight = inStream.readLong();
        this.hostnameInternal = inStream.readNormalisedString(512);
        this.portInternal = inStream.readInt();
        this.hostnameExternal = inStream.readNormalisedString(512);
        this.portExternal = inStream.readInt();
        if (version < 6) {
            this.sigPublicKey = (SerializablePublicKey)inStream.readSerializable(false, SerializablePublicKey::new);
            this.encPublicKey = (SerializablePublicKey)inStream.readSerializable(false, SerializablePublicKey::new);
            this.agreePublicKey = (SerializablePublicKey)inStream.readSerializable(false, SerializablePublicKey::new);
        } else {
            try {
                this.sigCert = this.checkCertificateEncoding((SerializableX509Certificate)inStream.readSerializable(false, SerializableX509Certificate::new));
                this.agreeCert = this.checkCertificateEncoding((SerializableX509Certificate)inStream.readSerializable(false, SerializableX509Certificate::new));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Deserialized certificate fails to generate binary encoding.", e);
            }
        }
        this.memo = inStream.readNormalisedString(512);
    }

    public static String ipString(byte[] ip) {
        return (0xFF & ip[0]) + "." + (0xFF & ip[1]) + "." + (0xFF & ip[2]) + "." + (0xFF & ip[3]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.equalsWithoutWeight(address) && this.weight == address.weight;
    }

    public boolean equalsWithoutWeight(@NonNull Address address) {
        return Objects.equals(this.id, address.id) && this.portInternal == address.portInternal && this.portExternal == address.portExternal && Objects.equals(this.nickname, address.nickname) && Objects.equals(this.selfName, address.selfName) && Objects.equals(this.hostnameInternal, address.hostnameInternal) && Objects.equals(this.hostnameExternal, address.hostnameExternal) && this.equalsPublicKey(this.sigPublicKey, address.sigPublicKey) && this.equalsPublicKey(this.agreePublicKey, address.agreePublicKey) && this.equalsCertificate(this.sigCert, address.sigCert) && this.equalsCertificate(this.agreeCert, address.agreeCert) && Objects.equals(this.memo, address.memo);
    }

    private boolean equalsPublicKey(@NonNull SerializablePublicKey publicKey1, @NonNull SerializablePublicKey publicKey2) {
        if (publicKey1 != null && publicKey2 != null) {
            return Arrays.equals(publicKey1.getPublicKey().getEncoded(), publicKey2.getPublicKey().getEncoded());
        }
        return publicKey1 == publicKey2;
    }

    private boolean equalsCertificate(@NonNull SerializableX509Certificate certificate1, @NonNull SerializableX509Certificate certificate2) {
        if (certificate1 != null && certificate2 != null) {
            try {
                return Arrays.equals(certificate1.getCertificate().getEncoded(), certificate2.getCertificate().getEncoded());
            }
            catch (CertificateEncodingException e) {
                return false;
            }
        }
        return certificate1 == certificate2;
    }

    @Nullable
    private SerializableX509Certificate checkCertificateEncoding(@Nullable SerializableX509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        return CryptoUtils.checkCertificate((Certificate)certificate.getCertificate()) ? certificate : null;
    }

    public int hashCode() {
        return NonCryptographicHashing.hash32((long)this.id.id());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("nickname", (Object)this.nickname).append("selfName", (Object)this.selfName).append("weight", (Object)this.weight).append("hostnameInternal", (Object)this.hostnameInternal).append("portInternalIpv4", (Object)this.portInternal).append("hostnameExternal", (Object)this.hostnameExternal).append("portExternalIpv4", (Object)this.portExternal).append("sigPublicKey", (Object)this.sigPublicKey).append("agreePublicKey", (Object)this.agreePublicKey).append("sigCert", (Object)this.sigCert).append("agreeCert", (Object)this.agreeCert).append("memo", (Object)this.memo).toString();
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 3;
        public static final int SELF_SERIALIZABLE_NODE_ID = 4;
        public static final int ADD_DNS_SUPPORT = 5;
        public static final int X509_CERT_SUPPORT = 6;

        private ClassVersion() {
        }
    }
}

