/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;

public class BlockingInputStream
extends InputStream {
    private final InputStream baseStream;
    boolean block;
    private final CountDownLatch latch = new CountDownLatch(1);

    public BlockingInputStream(InputStream baseStream) {
        this.baseStream = baseStream;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.block) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.baseStream.read(b, off, len);
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        if (this.block) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        return this.baseStream.readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        if (this.block) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.baseStream.readNBytes(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.baseStream.skip(n);
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        this.baseStream.skipNBytes(n);
    }

    @Override
    public int available() throws IOException {
        return this.baseStream.available();
    }

    @Override
    public void close() throws IOException {
        this.latch.countDown();
        this.baseStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.baseStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.baseStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.baseStream.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this.baseStream.transferTo(out);
    }

    @Override
    public int read() throws IOException {
        if (this.block) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        return this.baseStream.read();
    }

    public void blockAllReads() {
        this.block = true;
    }

    public boolean isClosed() {
        return this.latch.getCount() == 0L;
    }
}

