/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.set;

import com.swirlds.common.test.fixtures.set.RandomAccessSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;

public class RandomAccessHashSet<T>
implements RandomAccessSet<T> {
    private final Map<T, Integer> indices = new HashMap<T, Integer>();
    private final List<T> list = new ArrayList<T>();

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return this.indices.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T t) {
        if (this.indices.containsKey(t)) {
            return false;
        }
        int newIndex = this.list.size();
        this.list.add(t);
        this.indices.put(t, newIndex);
        return true;
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T get(Random random) {
        if (this.size() == 0) {
            throw new NoSuchElementException("can not get random element from empty set");
        }
        return this.get(random.nextInt(this.size()));
    }

    @Override
    public boolean remove(Object o) {
        int lastIndex;
        if (o == null || !this.indices.containsKey(o)) {
            return false;
        }
        int indexToRemove = this.indices.get(o);
        if (indexToRemove != (lastIndex = this.list.size() - 1)) {
            T gapFillingElement = this.list.get(lastIndex);
            this.list.set(indexToRemove, gapFillingElement);
            this.indices.put(gapFillingElement, indexToRemove);
        }
        this.list.remove(lastIndex);
        this.indices.remove(o);
        return true;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.indices.clear();
    }
}

