/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.stream;

import com.swirlds.common.stream.HashCalculatorForStream;
import com.swirlds.common.stream.QueueThreadObjectStream;
import com.swirlds.common.stream.QueueThreadObjectStreamConfiguration;
import com.swirlds.common.stream.RunningHashCalculatorForStream;
import com.swirlds.common.stream.StreamType;
import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.common.stream.internal.TimestampStreamFileWriter;
import com.swirlds.common.test.fixtures.stream.ObjectForTestStream;
import com.swirlds.common.test.fixtures.stream.ObjectForTestStreamGenerator;
import com.swirlds.common.test.fixtures.stream.TestStreamType;
import com.swirlds.common.test.fixtures.stream.WriteToStreamConsumer;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signer;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class StreamObjectWorker {
    private final QueueThreadObjectStream<ObjectForTestStream> writeQueueThread;
    private Iterator<ObjectForTestStream> iterator;
    private QueueThreadObjectStream<ObjectForTestStream> hashQueueThread;
    private int remainNum;
    private Deque<SelfSerializable> addedObjects;

    public StreamObjectWorker(int totalNum, int intervalMs, String dirPath, int logPeriodMs, Hash initialHash, boolean startWriteAtCompleteWindow, Instant firstTimestamp, Signer signer) throws NoSuchAlgorithmException {
        TimestampStreamFileWriter fileWriter = new TimestampStreamFileWriter(dirPath, (long)logPeriodMs, signer, startWriteAtCompleteWindow, (StreamType)TestStreamType.TEST_STREAM);
        this.writeQueueThread = new QueueThreadObjectStreamConfiguration(AdHocThreadManager.getStaticThreadManager()).setForwardTo((LinkedObjectStream)fileWriter).build();
        this.writeQueueThread.start();
        this.initialize(totalNum, intervalMs, initialHash, firstTimestamp);
    }

    public StreamObjectWorker(int totalNum, int intervalMs, Hash initialHash, Instant firstTimestamp, SerializableDataOutputStream stream) throws IOException {
        WriteToStreamConsumer streamWriter = new WriteToStreamConsumer(stream, initialHash);
        this.writeQueueThread = new QueueThreadObjectStreamConfiguration(AdHocThreadManager.getStaticThreadManager()).setForwardTo((LinkedObjectStream)streamWriter).build();
        this.writeQueueThread.start();
        this.initialize(totalNum, intervalMs, initialHash, firstTimestamp);
    }

    private void initialize(int totalNum, int intervalMs, Hash initialHash, Instant firstTimestamp) {
        this.remainNum = totalNum;
        this.iterator = new ObjectForTestStreamGenerator(totalNum, intervalMs, firstTimestamp).getIterator();
        RunningHashCalculatorForStream runningHashCalculator = new RunningHashCalculatorForStream(this.writeQueueThread);
        HashCalculatorForStream hashCalculator = new HashCalculatorForStream((LinkedObjectStream)runningHashCalculator);
        this.hashQueueThread = new QueueThreadObjectStreamConfiguration(AdHocThreadManager.getStaticThreadManager()).setForwardTo((LinkedObjectStream)hashCalculator).build();
        this.hashQueueThread.setRunningHash(initialHash);
        this.hashQueueThread.start();
        this.addedObjects = new LinkedList<SelfSerializable>();
    }

    public void work() {
        while (this.remainNum > 0 && this.iterator.hasNext()) {
            ObjectForTestStream object = this.iterator.next();
            this.hashQueueThread.getQueue().add(object);
            this.addedObjects.add((SelfSerializable)object);
            if (!this.iterator.hasNext()) {
                this.hashQueueThread.close();
            }
            --this.remainNum;
        }
    }

    public Deque<SelfSerializable> getAddedObjects() {
        return this.addedObjects;
    }
}

