/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.swirlds.common.utility.throttle.Throttle;
import com.swirlds.demo.platform.PAYLOAD_CATEGORY;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PlatformTestingToolMain;
import com.swirlds.demo.platform.TransactionSubmitter;
import com.swirlds.logging.legacy.LogMarker;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class SubmitConfig {
    private static final Logger logger = LogManager.getLogger(PlatformTestingToolMain.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");
    private TransactionSubmitter.SUBMIT_GOAL systemMetric = TransactionSubmitter.SUBMIT_GOAL.BYTES_PER_SECOND_PER_NODE;
    private float metricThreshold = 1000.0f;
    private long pauseAfter = 0L;
    private int pauseSeconds = 15;
    private boolean allowRunSubmit = true;
    private int C2CDelayThreshold = 5;
    private boolean singleNodeSubmit = false;
    private boolean submitInTurn = false;
    private int inTurnIntervalSecond = 0;
    private boolean enableThrottling = false;
    private int sleepAfterTestMs = 90000;
    private Map<String, String> tpsMap = null;
    private Map<PAYLOAD_TYPE, Throttle> throttleForTxTypes = null;
    private Map<String, String> categoryTpsMap = null;
    private Map<PAYLOAD_CATEGORY, Throttle> throttleForTxCategory = null;

    public Map<String, String> getTpsMap() {
        return this.tpsMap;
    }

    public void setTpsMap(Map<String, String> tpsMap) {
        this.tpsMap = tpsMap;
    }

    public Map<String, String> getCategoryTpsMap() {
        return this.categoryTpsMap;
    }

    public void setCategoryTpsMap(Map<String, String> categoryTpsMap) {
        this.categoryTpsMap = categoryTpsMap;
    }

    public TransactionSubmitter.SUBMIT_GOAL getSystemMetric() {
        return this.systemMetric;
    }

    public void setSystemMetric(TransactionSubmitter.SUBMIT_GOAL systemMetric) {
        this.systemMetric = systemMetric;
    }

    public float getMetricThreshold() {
        return this.metricThreshold;
    }

    public void setMetricThreshold(float metricThreshold) {
        this.metricThreshold = metricThreshold;
    }

    public long getPauseAfter() {
        return this.pauseAfter;
    }

    public void setPauseAfter(long pauseAfter) {
        this.pauseAfter = pauseAfter;
    }

    public int getPauseSeconds() {
        return this.pauseSeconds;
    }

    public void setPauseSeconds(int pauseSeconds) {
        this.pauseSeconds = pauseSeconds;
    }

    public boolean isAllowRunSubmit() {
        return this.allowRunSubmit;
    }

    public void setAllowRunSubmit(boolean allowRunSubmit) {
        this.allowRunSubmit = allowRunSubmit;
    }

    public int getC2CDelayThreshold() {
        return this.C2CDelayThreshold;
    }

    public void setC2CDelayThreshold(int c2cDelayThreshold) {
        this.C2CDelayThreshold = c2cDelayThreshold;
    }

    public boolean isSingleNodeSubmit() {
        return this.singleNodeSubmit;
    }

    public void setSingleNodeSubmit(boolean singleNodeSubmit) {
        this.singleNodeSubmit = singleNodeSubmit;
    }

    public boolean isSubmitInTurn() {
        return this.submitInTurn;
    }

    public void setSubmitInTurn(boolean submitInTurn) {
        this.submitInTurn = submitInTurn;
    }

    public int getInTurnIntervalSecond() {
        return this.inTurnIntervalSecond;
    }

    public void setInTurnIntervalSecond(int inTurnIntervalSecond) {
        this.inTurnIntervalSecond = inTurnIntervalSecond;
    }

    public boolean isEnableThrottling() {
        return this.enableThrottling;
    }

    public void setEnableThrottling(boolean enableThrottling) {
        this.enableThrottling = enableThrottling;
    }

    public int getSleepAfterTestMs() {
        return this.sleepAfterTestMs;
    }

    public void setSleepAfterTestMs(int sleepAfterTestMs) {
        this.sleepAfterTestMs = sleepAfterTestMs;
    }

    public Map<PAYLOAD_TYPE, Throttle> getThrottleForTxTypes() {
        return this.throttleForTxTypes;
    }

    public Map<PAYLOAD_CATEGORY, Throttle> getThrottleForTxCategory() {
        return this.throttleForTxCategory;
    }

    public void initThrottling() {
        if (this.categoryTpsMap != null) {
            this.loadCategoryTpsMap();
        }
        if (this.tpsMap != null) {
            this.loadTpsMap();
        }
    }

    void loadCategoryTpsMap() {
        this.throttleForTxCategory = new HashMap<PAYLOAD_CATEGORY, Throttle>(this.categoryTpsMap.size());
        this.categoryTpsMap.forEach((txCategoryName, tps) -> {
            try {
                PAYLOAD_CATEGORY txCategory = PAYLOAD_CATEGORY.valueOf(txCategoryName);
                Throttle throttle = new Throttle(Double.parseDouble(tps));
                this.throttleForTxCategory.put(txCategory, throttle);
            }
            catch (IllegalArgumentException ex) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Name {} is not a valid transaction category or {} is not a valid value.", txCategoryName, tps);
            }
        });
    }

    void loadTpsMap() {
        this.throttleForTxTypes = new HashMap<PAYLOAD_TYPE, Throttle>(this.tpsMap.size());
        this.tpsMap.forEach((txTypeName, tps) -> {
            try {
                PAYLOAD_TYPE txType = PAYLOAD_TYPE.valueOf(txTypeName);
                Throttle throttle = new Throttle(Double.parseDouble(tps));
                this.throttleForTxTypes.put(txType, throttle);
            }
            catch (IllegalArgumentException ex) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Name {} is not a valid transaction type or {} is not a valid value.", txTypeName, tps);
            }
        });
    }
}

