/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.test.fixtures;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import org.hiero.base.crypto.test.fixtures.EcdsaUtils;
import org.hiero.base.crypto.test.fixtures.SigningProvider;

public class ECDSASigningProvider
implements SigningProvider {
    private KeyPair activeKp;
    private boolean algorithmAvailable = false;
    private final MessageDigest keccakDigest;

    public ECDSASigningProvider() {
        this.generateActiveKeyPair();
        this.keccakDigest = this.createKeccakDigest();
    }

    @Override
    public byte[] sign(byte[] msg) throws SignatureException {
        return EcdsaUtils.signDigestWithEcdsaSecp256k1(this.activeKp.getPrivate(), this.keccak256(msg));
    }

    @Override
    public byte[] getPublicKeyBytes() {
        return EcdsaUtils.asRawEcdsaSecp256k1Key((ECPublicKey)this.activeKp.getPublic());
    }

    @Override
    public int getSignatureLength() {
        return 64;
    }

    @Override
    public byte[] getPrivateKeyBytes() {
        return this.activeKp.getPublic().getEncoded();
    }

    @Override
    public boolean isAlgorithmAvailable() {
        return this.algorithmAvailable;
    }

    void generateActiveKeyPair() {
        try {
            this.activeKp = EcdsaUtils.genEcdsaSecp256k1KeyPair();
            this.algorithmAvailable = true;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException fatal) {
            throw new IllegalStateException("Tests cannot be trusted without working key-pair generation", fatal);
        }
    }

    private MessageDigest createKeccakDigest() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("KECCAK-256");
        }
        catch (NoSuchAlgorithmException ignored) {
            try {
                digest = MessageDigest.getInstance("SHA3-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return digest;
    }

    private byte[] keccak256(byte[] bytes) {
        this.keccakDigest.reset();
        this.keccakDigest.update(bytes);
        return this.keccakDigest.digest();
    }
}

