/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.hints.codec;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.node.state.hints.HintsScheme;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class HintsConstructionJsonCodec
implements JsonCodec<HintsConstruction> {
    public static final OneOf<HintsConstruction.PreprocessingStateOneOfType> PREPROCESSING_STATE_UNSET = new OneOf((Enum)HintsConstruction.PreprocessingStateOneOfType.UNSET, null);

    @NonNull
    public HintsConstruction parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_construction_id = 0L;
            Bytes temp_source_roster_hash = Bytes.EMPTY;
            Bytes temp_target_roster_hash = Bytes.EMPTY;
            OneOf temp_preprocessing_state = PREPROCESSING_STATE_UNSET;
            block18: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "constructionId": {
                        temp_construction_id = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "sourceRosterHash": {
                        temp_source_roster_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"source_roster_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block18;
                    }
                    case "targetRosterHash": {
                        temp_target_roster_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"target_roster_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block18;
                    }
                    case "gracePeriodEndTime": {
                        temp_preprocessing_state = new OneOf((Enum)HintsConstruction.PreprocessingStateOneOfType.GRACE_PERIOD_END_TIME, Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block18;
                    }
                    case "preprocessingStartTime": {
                        temp_preprocessing_state = new OneOf((Enum)HintsConstruction.PreprocessingStateOneOfType.PREPROCESSING_START_TIME, Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block18;
                    }
                    case "hintsScheme": {
                        temp_preprocessing_state = new OneOf((Enum)HintsConstruction.PreprocessingStateOneOfType.HINTS_SCHEME, HintsScheme.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block18;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new HintsConstruction(temp_construction_id, temp_source_roster_hash, temp_target_roster_hash, temp_preprocessing_state);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull HintsConstruction data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.constructionId() != 0L) {
            fieldLines.add(JsonTools.field((String)"constructionId", (long)data.constructionId()));
        }
        if (data.sourceRosterHash() != Bytes.EMPTY && data.sourceRosterHash() != null && data.sourceRosterHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"sourceRosterHash", (Bytes)data.sourceRosterHash()));
        }
        if (data.targetRosterHash() != Bytes.EMPTY && data.targetRosterHash() != null && data.targetRosterHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"targetRosterHash", (Bytes)data.targetRosterHash()));
        }
        if (data.preprocessingState().kind() == HintsConstruction.PreprocessingStateOneOfType.GRACE_PERIOD_END_TIME) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"gracePeriodEndTime", Timestamp.JSON, (Object)data.gracePeriodEndTime()));
        }
        if (data.preprocessingState().kind() == HintsConstruction.PreprocessingStateOneOfType.PREPROCESSING_START_TIME) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"preprocessingStartTime", Timestamp.JSON, (Object)data.preprocessingStartTime()));
        }
        if (data.preprocessingState().kind() == HintsConstruction.PreprocessingStateOneOfType.HINTS_SCHEME) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"hintsScheme", HintsScheme.JSON, (Object)data.hintsScheme()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

