/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.file.FileGetContentsQuery;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.spi.fees.QueryFeeCalculator;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class FileGetContentsFeeCalculator
implements QueryFeeCalculator {
    public void accumulateNodePayment(@NonNull Query query, @Nullable QueryContext queryContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        ReadableFileStore fileStore = (ReadableFileStore)queryContext.createStore(ReadableFileStore.class);
        FileGetContentsQuery op = query.fileGetContentsOrThrow();
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.FILE_GET_CONTENTS);
        Bytes fileContents = fileStore.getFileLeaf(op.fileIDOrThrow()).contents();
        feeResult.addServiceFee(1L, serviceDef.baseFee());
        this.addExtraFee(feeResult, serviceDef, Extra.BYTES, feeSchedule, fileContents.length());
    }

    public Query.QueryOneOfType getQueryType() {
        return Query.QueryOneOfType.FILE_GET_CONTENTS;
    }
}

