/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import java.util.Objects;

public final class KeyRange {
    public static final long INVALID_KEY = -1L;
    public static final KeyRange INVALID_KEY_RANGE = new KeyRange(-1L, -1L);
    private final long minValidKey;
    private final long maxValidKey;

    public KeyRange(long minValidKey, long maxValidKey) {
        if (maxValidKey < minValidKey) {
            throw new IllegalArgumentException("maxValidKey of " + maxValidKey + " must be less than minValidKey of " + minValidKey);
        }
        this.minValidKey = minValidKey;
        this.maxValidKey = maxValidKey;
    }

    public long getMinValidKey() {
        return this.minValidKey;
    }

    public long getMaxValidKey() {
        return this.maxValidKey;
    }

    public boolean withinRange(long key) {
        return key >= this.minValidKey && key <= this.maxValidKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyRange keyRange = (KeyRange)o;
        return this.minValidKey == keyRange.minValidKey && this.maxValidKey == keyRange.maxValidKey;
    }

    public int hashCode() {
        return Objects.hash(this.minValidKey, this.maxValidKey);
    }

    public String toString() {
        return "(" + this.minValidKey + "," + this.maxValidKey + ")";
    }
}

