/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

@Deprecated
public final class MerkleDbTableConfig
implements SelfSerializable {
    private static final long CLASS_ID = -4953423115946634692L;
    private static final FieldDefinition FIELD_TABLECONFIG_HASHVERSION = new FieldDefinition("hashVersion", FieldType.UINT32, false, true, false, 1);
    private static final FieldDefinition FIELD_TABLECONFIG_DIGESTTYPEID = new FieldDefinition("digestTypeId", FieldType.UINT32, false, false, false, 2);
    @Deprecated
    private static final FieldDefinition FIELD_TABLECONFIG_KEYVERSION = new FieldDefinition("keyVersion", FieldType.UINT32, false, true, false, 3);
    @Deprecated
    private static final FieldDefinition FIELD_TABLECONFIG_KEYSERIALIZERCLSID = new FieldDefinition("keySerializerClassId", FieldType.UINT64, false, false, false, 4);
    @Deprecated
    private static final FieldDefinition FIELD_TABLECONFIG_VALUEVERSION = new FieldDefinition("valueVersion", FieldType.UINT32, false, true, false, 5);
    @Deprecated
    private static final FieldDefinition FIELD_TABLECONFIG_VALUESERIALIZERCLSID = new FieldDefinition("valueSerializerClassId", FieldType.UINT64, false, false, false, 6);
    @Deprecated
    private static final FieldDefinition FIELD_TABLECONFIG_PREFERDISKINDICES = new FieldDefinition("preferDiskIndices", FieldType.UINT32, false, true, false, 7);
    private static final FieldDefinition FIELD_TABLECONFIG_INITIALCAPACITY = new FieldDefinition("initialCapacity", FieldType.UINT64, false, true, false, 8);
    private static final FieldDefinition FIELD_TABLECONFIG_HASHRAMTODISKTHRESHOLD = new FieldDefinition("hashesRamToDiskThreshold", FieldType.UINT64, false, true, false, 9);
    private short hashVersion;
    private DigestType hashType;
    private long initialCapacity;
    private long hashesRamToDiskThreshold;

    public MerkleDbTableConfig() {
    }

    public MerkleDbTableConfig(short hashVersion, DigestType hashType, long initialCapacity, long hashesRamToDiskThreshold) {
        this.hashVersion = hashVersion;
        this.hashType = hashType;
        if (initialCapacity <= 0L) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        this.initialCapacity = initialCapacity;
        if (hashesRamToDiskThreshold < 0L) {
            throw new IllegalArgumentException("Hashes RAM/disk threshold must be greater or equal to 0");
        }
        this.hashesRamToDiskThreshold = hashesRamToDiskThreshold;
    }

    public MerkleDbTableConfig(ReadableSequentialData in) {
        this.hashVersion = 0;
        this.hashType = DigestType.SHA_384;
        this.initialCapacity = 0L;
        this.hashesRamToDiskThreshold = 0L;
        while (in.hasRemaining()) {
            int tag = in.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum == FIELD_TABLECONFIG_HASHVERSION.number()) {
                this.hashVersion = (short)in.readVarInt(false);
                continue;
            }
            if (fieldNum == FIELD_TABLECONFIG_DIGESTTYPEID.number()) {
                int digestTypeId = in.readVarInt(false);
                this.hashType = DigestType.valueOf((int)digestTypeId);
                continue;
            }
            if (fieldNum == FIELD_TABLECONFIG_KEYVERSION.number()) {
                in.readVarInt(false);
                continue;
            }
            if (fieldNum == FIELD_TABLECONFIG_KEYSERIALIZERCLSID.number()) {
                long classId = in.readVarLong(false);
                throw new UnsupportedOperationException("Cannot deserialize MerkleDb table config with key serializer");
            }
            if (fieldNum == FIELD_TABLECONFIG_VALUEVERSION.number()) {
                in.readVarInt(false);
                continue;
            }
            if (fieldNum == FIELD_TABLECONFIG_VALUESERIALIZERCLSID.number()) {
                long classId = in.readVarLong(false);
                throw new UnsupportedOperationException("Cannot deserialize MerkleDb table config with value serializer");
            }
            if (fieldNum == FIELD_TABLECONFIG_PREFERDISKINDICES.number()) {
                in.readVarInt(false);
                continue;
            }
            if (fieldNum == FIELD_TABLECONFIG_INITIALCAPACITY.number()) {
                this.initialCapacity = in.readVarLong(false);
                continue;
            }
            if (fieldNum == FIELD_TABLECONFIG_HASHRAMTODISKTHRESHOLD.number()) {
                this.hashesRamToDiskThreshold = in.readVarLong(false);
                continue;
            }
            throw new IllegalArgumentException("Unknown table config field: " + fieldNum);
        }
        Objects.requireNonNull(this.hashType, "Null or wrong hash type");
        if (this.initialCapacity <= 0L) {
            throw new IllegalArgumentException("Missing or wrong initial capacity");
        }
    }

    public int pbjSizeInBytes() {
        int size = 0;
        if (this.hashVersion != 0) {
            size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_TABLECONFIG_HASHVERSION, (ProtoConstants)ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
            size += ProtoWriterTools.sizeOfVarInt32((int)this.hashVersion);
        }
        size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_TABLECONFIG_DIGESTTYPEID, (ProtoConstants)ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        size += ProtoWriterTools.sizeOfVarInt32((int)this.hashType.id());
        assert (this.initialCapacity != 0L);
        size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_TABLECONFIG_INITIALCAPACITY, (ProtoConstants)ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        size += ProtoWriterTools.sizeOfVarInt64((long)this.initialCapacity);
        if (this.hashesRamToDiskThreshold != 0L) {
            size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_TABLECONFIG_HASHRAMTODISKTHRESHOLD, (ProtoConstants)ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
            size += ProtoWriterTools.sizeOfVarInt64((long)this.hashesRamToDiskThreshold);
        }
        return size;
    }

    public void writeTo(WritableSequentialData out) {
        if (this.hashVersion != 0) {
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_TABLECONFIG_HASHVERSION);
            out.writeVarInt((int)this.hashVersion, false);
        }
        ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_TABLECONFIG_DIGESTTYPEID);
        out.writeVarInt(this.hashType.id(), false);
        assert (this.initialCapacity != 0L);
        ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_TABLECONFIG_INITIALCAPACITY);
        out.writeVarLong(this.initialCapacity, false);
        if (this.hashesRamToDiskThreshold != 0L) {
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_TABLECONFIG_HASHRAMTODISKTHRESHOLD);
            out.writeVarLong(this.hashesRamToDiskThreshold, false);
        }
    }

    public short getHashVersion() {
        return this.hashVersion;
    }

    public DigestType getHashType() {
        return this.hashType;
    }

    public long getInitialCapacity() {
        return this.initialCapacity;
    }

    public long getHashesRamToDiskThreshold() {
        return this.hashesRamToDiskThreshold;
    }

    public long getClassId() {
        return -4953423115946634692L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeBoolean(false);
        out.writeLong(this.initialCapacity);
        out.writeLong(this.hashesRamToDiskThreshold);
        out.writeShort((int)this.hashVersion);
        out.writeInt(this.hashType.id());
        out.writeShort(0);
        out.writeSerializable(null, true);
        out.writeShort(0);
        out.writeSerializable(null, true);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        in.readBoolean();
        this.initialCapacity = in.readLong();
        this.hashesRamToDiskThreshold = in.readLong();
        this.hashVersion = in.readShort();
        this.hashType = DigestType.valueOf((int)in.readInt());
        in.readShort();
        in.readSerializable();
        in.readShort();
        in.readSerializable();
    }

    public MerkleDbTableConfig copy() {
        return new MerkleDbTableConfig(this.hashVersion, this.hashType, this.initialCapacity, this.hashesRamToDiskThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.hashVersion, this.hashType, this.initialCapacity, this.hashesRamToDiskThreshold);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MerkleDbTableConfig)) {
            return false;
        }
        MerkleDbTableConfig other = (MerkleDbTableConfig)o;
        return this.initialCapacity == other.initialCapacity && this.hashesRamToDiskThreshold == other.hashesRamToDiskThreshold && this.hashVersion == other.hashVersion && Objects.equals(this.hashType, other.hashType);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

