/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.PlatformCli;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.platform.config.AddressBookConfig;
import com.swirlds.platform.config.DefaultConfiguration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.config.EventConfig;
import picocli.CommandLine;

@CommandLine.Command(name="clean", mixinStandardHelpOptions=true, description={"Delete all files generated by running the platform."})
@SubcommandOf(value=PlatformCli.class)
public final class CleanCommand
extends AbstractCommand {
    private Path sdkPath;

    @CommandLine.Parameters(description={"the path to the sdk directory"})
    private void setSdkPath(Path sdkPath) {
        this.sdkPath = this.dirMustExist(sdkPath.toAbsolutePath());
    }

    public Integer call() throws Exception {
        CleanCommand.clean(this.sdkPath);
        return 0;
    }

    public static void clean(@NonNull Path sdkPath) throws IOException {
        Objects.requireNonNull(sdkPath);
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create(), sdkPath.resolve("settings.txt"), List.of(sdkPath.resolve("config.txt")));
        FileUtils.deleteFiles((Path)sdkPath, (String)".log");
        FileUtils.deleteFiles((Path)sdkPath, (String)".csv");
        FileUtils.deleteFiles((Path)sdkPath, (String)"metricsDoc.tsv");
        FileUtils.deleteFiles((Path)sdkPath, (String)"settingsUsed.txt");
        FileUtils.deleteDirectory((Path)sdkPath.resolve(((AddressBookConfig)configuration.getConfigData(AddressBookConfig.class)).addressBookDirectory()));
        FileUtils.deleteDirectory((Path)sdkPath.resolve(((StateCommonConfig)configuration.getConfigData(StateCommonConfig.class)).savedStateDirectory()));
        FileUtils.deleteDirectory((Path)sdkPath.resolve(((EventConfig)configuration.getConfigData(EventConfig.class)).eventsLogDir()));
    }
}

