/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system.address;

import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.formatting.TextTable;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.text.ParseException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.model.roster.AddressBook;

public class AddressBookUtils {
    public static final String ADDRESS_KEYWORD = "address";
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("^((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}$");

    private AddressBookUtils() {
    }

    @NonNull
    public static String addressBookConfigText(@NonNull AddressBook addressBook) {
        Objects.requireNonNull(addressBook, "The addressBook must not be null.");
        TextTable table = new TextTable().setBordersEnabled(false);
        for (Address address : addressBook) {
            String memo = address.getMemo();
            boolean hasMemo = !memo.trim().isEmpty();
            boolean hasInternalIpv4 = address.getHostnameInternal() != null;
            boolean hasExternalIpv4 = address.getHostnameExternal() != null;
            table.addRow(new Object[]{"address,", String.valueOf(address.getNodeId()) + ",", address.getNickname() + ",", address.getSelfName() + ",", address.getWeight() + ",", (hasInternalIpv4 ? address.getHostnameInternal() : "") + ",", address.getPortInternal() + ",", (hasExternalIpv4 ? address.getHostnameExternal() : "") + ",", address.getPortExternal() + (hasMemo ? "," : ""), memo});
        }
        return table.render();
    }

    @NonNull
    public static AddressBook parseAddressBookText(@NonNull String addressBookText) throws ParseException {
        Objects.requireNonNull(addressBookText, "The addressBookText must not be null.");
        AddressBook addressBook = new AddressBook();
        for (String line : addressBookText.split("\\r?\\n")) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("#") || trimmedLine.startsWith("swirld") || trimmedLine.startsWith("app")) continue;
            if (trimmedLine.startsWith(ADDRESS_KEYWORD)) {
                Address address = AddressBookUtils.parseAddressText(trimmedLine);
                if (address == null) continue;
                addressBook.add(address);
                continue;
            }
            if (trimmedLine.startsWith("nextNodeId")) continue;
            throw new ParseException("The line [%s] does not start with `%s`.".formatted(line.substring(0, Math.min(line.length(), 30)), ADDRESS_KEYWORD), 0);
        }
        return addressBook;
    }

    @Nullable
    public static Address parseAddressText(@NonNull String addressText) throws ParseException {
        int externalPort;
        int internalPort;
        long weight;
        NodeId nodeId;
        Objects.requireNonNull(addressText, "The addressText must not be null.");
        String[] textAndComment = addressText.split("#");
        if (textAndComment.length == 0 || textAndComment[0] == null || textAndComment[0].trim().isEmpty()) {
            return null;
        }
        String[] parts = addressText.split(",");
        if (parts.length < 9 || parts.length > 10) {
            throw new ParseException("Incorrect number of parts in the address line to parse correctly.", parts.length);
        }
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        if (!parts[0].equals(ADDRESS_KEYWORD)) {
            throw new ParseException("The address line must start with 'address' and not '" + parts[0] + "'", 0);
        }
        try {
            nodeId = NodeId.of((long)Long.parseLong(parts[1]));
        }
        catch (Exception e) {
            throw new ParseException("Cannot parse node id from '" + parts[1] + "'", 1);
        }
        String nickname = parts[2];
        String selfname = parts[3];
        try {
            weight = Long.parseLong(parts[4]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse value of weight from '" + parts[4] + "'", 4);
        }
        String internalHostname = parts[5];
        try {
            internalPort = Integer.parseInt(parts[6]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse ip port from '" + parts[6] + "'", 6);
        }
        String externalHostname = parts[7];
        try {
            externalPort = Integer.parseInt(parts[8]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse ip port from '" + parts[8] + "'", 8);
        }
        String memoToUse = parts.length == 10 ? parts[9] : "";
        return new Address(nodeId, nickname, selfname, weight, internalHostname, internalPort, externalHostname, externalPort, null, null, memoToUse);
    }

    public static ServiceEndpoint endpointFor(@NonNull String host, int port) {
        ServiceEndpoint.Builder builder = ServiceEndpoint.newBuilder().port(port);
        if (IPV4_ADDRESS_PATTERN.matcher(host).matches()) {
            String[] octets = host.split("[.]");
            builder.ipAddressV4(Bytes.wrap((byte[])new byte[]{(byte)Integer.parseInt(octets[0]), (byte)Integer.parseInt(octets[1]), (byte)Integer.parseInt(octets[2]), (byte)Integer.parseInt(octets[3])}));
        } else {
            builder.domainName(host);
        }
        return builder.build();
    }
}

