/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.LearningSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.stats.ReconnectMapStats;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.ExpectedLesson;
import com.swirlds.common.merkle.synchronization.task.LearnerPushTask;
import com.swirlds.common.merkle.synchronization.task.Lesson;
import com.swirlds.common.merkle.synchronization.task.ReconnectNodeCount;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualMapMetadata;
import com.swirlds.virtualmap.internal.reconnect.BooleanBitSetQueue;
import com.swirlds.virtualmap.internal.reconnect.ConcurrentBitSetQueue;
import com.swirlds.virtualmap.internal.reconnect.ReconnectNodeRemover;
import com.swirlds.virtualmap.internal.reconnect.VirtualReconnectUtils;
import com.swirlds.virtualmap.internal.reconnect.VirtualTreeViewBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;

public final class LearnerPushVirtualTreeView
extends VirtualTreeViewBase
implements LearnerTreeView<Long> {
    private static final Logger logger = LogManager.getLogger(LearnerPushVirtualTreeView.class);
    private static final int EXPECTED_BIT_SET_INITIAL_CAPACITY = 0x100000;
    private final ReconnectConfig reconnectConfig;
    private AsyncInputStream<Lesson<Long>> in;
    private final ReconnectNodeRemover nodeRemover;
    private final BooleanBitSetQueue expectedNodeAlreadyPresent = new BooleanBitSetQueue(0x100000);
    private final ConcurrentBitSetQueue expectedChildren = new ConcurrentBitSetQueue();
    private final BooleanBitSetQueue expectedOriginalExists = new BooleanBitSetQueue(0x100000);
    private final RecordAccessor originalRecords;
    private final ReconnectMapStats mapStats;

    public LearnerPushVirtualTreeView(@NonNull ReconnectConfig reconnectConfig, @NonNull VirtualMap map, @NonNull RecordAccessor originalRecords, @NonNull VirtualMapMetadata originalState, @NonNull VirtualMapMetadata reconnectState, @NonNull ReconnectNodeRemover nodeRemover, @NonNull ReconnectMapStats mapStats) {
        super(map, originalState, reconnectState);
        this.reconnectConfig = Objects.requireNonNull(reconnectConfig);
        this.originalRecords = Objects.requireNonNull(originalRecords);
        this.nodeRemover = Objects.requireNonNull(nodeRemover);
        this.mapStats = Objects.requireNonNull(mapStats);
    }

    public void startLearnerTasks(LearningSynchronizer learningSynchronizer, StandardWorkGroup workGroup, MerkleDataInputStream inputStream, MerkleDataOutputStream outputStream, Queue<MerkleNode> rootsToReceive, AtomicReference<Long> reconstructedRoot) {
        this.in = new AsyncInputStream((SerializableDataInputStream)inputStream, workGroup, () -> new Lesson((LearnerTreeView)this), this.reconnectConfig);
        this.in.start();
        AsyncOutputStream out = learningSynchronizer.buildOutputStream(workGroup, (SerializableDataOutputStream)outputStream);
        out.start();
        LearnerPushTask learnerThread = new LearnerPushTask(workGroup, this.in, out, rootsToReceive, reconstructedRoot, (LearnerTreeView)this, (ReconnectNodeCount)learningSynchronizer, this.mapStats);
        learnerThread.start();
    }

    public void abort() {
        this.in.abort();
    }

    public boolean isRootOfState() {
        return false;
    }

    public Long getOriginalRoot() {
        return 0L;
    }

    public Hash getNodeHash(Long originalChild) {
        if (originalChild == null) {
            return Cryptography.NULL_HASH;
        }
        this.checkValidNode(originalChild, this.originalState);
        Hash hash = this.originalRecords.findHash(originalChild);
        if (hash == null) {
            throw new MerkleSynchronizationException("Node found, but hash was null. path=" + originalChild);
        }
        return hash;
    }

    public void expectLessonFor(Long parent, int childIndex, Long original, boolean nodeAlreadyPresent) {
        this.expectedChildren.add(parent == null ? 0L : Path.getChildPath(parent, childIndex));
        this.expectedNodeAlreadyPresent.add(nodeAlreadyPresent);
        this.expectedOriginalExists.add(original != null);
    }

    public ExpectedLesson<Long> getNextExpectedLesson() {
        long child = this.expectedChildren.remove();
        long parent = Path.getParentPath(child);
        int index = Path.isLeft(child) ? 0 : 1;
        Long original = this.expectedOriginalExists.remove() ? Long.valueOf(child) : null;
        boolean nodeAlreadyPresent = this.expectedNodeAlreadyPresent.remove();
        return new ExpectedLesson((Object)parent, index, (Object)original, nodeAlreadyPresent);
    }

    public boolean hasNextExpectedLesson() {
        assert (this.expectedOriginalExists.isEmpty() == this.expectedChildren.isEmpty() && this.expectedChildren.isEmpty() == this.expectedNodeAlreadyPresent.isEmpty()) : "All three should match";
        return !this.expectedOriginalExists.isEmpty();
    }

    public Long deserializeLeaf(SerializableDataInputStream in) throws IOException {
        VirtualLeafBytes leaf = VirtualReconnectUtils.readLeafRecord(in);
        this.nodeRemover.newLeafNode(leaf.path(), leaf.keyBytes());
        this.map.handleReconnectLeaf(leaf);
        return leaf.path();
    }

    public Long deserializeInternal(SerializableDataInputStream in) throws IOException {
        long node = in.readLong();
        if (node == 0L) {
            long firstLeafPath = in.readLong();
            long lastLeafPath = in.readLong();
            this.reconnectState.setLastLeafPath(lastLeafPath);
            this.reconnectState.setFirstLeafPath(firstLeafPath);
            this.map.prepareReconnectHashing(firstLeafPath, lastLeafPath);
            this.nodeRemover.setPathInformation(firstLeafPath, lastLeafPath);
        }
        return node;
    }

    public void initialize() {
    }

    public void close() {
        logger.info(LogMarker.RECONNECT.getMarker(), "call nodeRemover.allNodesReceived()");
        this.nodeRemover.allNodesReceived();
        logger.info(LogMarker.RECONNECT.getMarker(), "call root.endLearnerReconnect()");
        this.map.endLearnerReconnect();
        logger.info(LogMarker.RECONNECT.getMarker(), "close() complete");
    }

    public void markForInitialization(Long node) {
    }

    public void releaseNode(Long node) {
    }

    public void setChild(Long parent, int childIndex, Long child) {
    }

    public Long convertMerkleRootToViewType(MerkleNode node) {
        throw new UnsupportedOperationException("Nested virtual maps not supported");
    }

    private boolean isLeaf(long path) {
        return path >= this.reconnectState.getFirstLeafPath() && path <= this.reconnectState.getLastLeafPath();
    }

    public void recordHashStats(@NonNull ReconnectMapStats mapStats, @NonNull Long parent, int childIndex, boolean nodeAlreadyPresent) {
        long childPath = Path.getChildPath(parent, childIndex);
        if (this.isLeaf(childPath)) {
            mapStats.incrementLeafHashes(1, nodeAlreadyPresent ? 1 : 0);
        } else {
            mapStats.incrementInternalHashes(1, nodeAlreadyPresent ? 1 : 0);
        }
    }
}

