/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.internal;

import java.util.Optional;
import java.util.OptionalInt;

public record EvmConfiguration(long jumpDestCacheWeightKB, WorldUpdaterMode worldUpdaterMode, Integer evmStackSize, Optional<Integer> maxCodeSizeOverride, Optional<Integer> maxInitcodeSizeOverride) {
    public static final EvmConfiguration DEFAULT = new EvmConfiguration(32000L, WorldUpdaterMode.STACKED);

    public EvmConfiguration(Long jumpDestCacheWeightKilobytes, WorldUpdaterMode worldstateUpdateMode) {
        this(jumpDestCacheWeightKilobytes, worldstateUpdateMode, 1024, Optional.empty(), Optional.empty());
    }

    public long getJumpDestCacheWeightBytes() {
        return this.jumpDestCacheWeightKB * 1024L;
    }

    public EvmConfiguration overrides(OptionalInt newMaxCodeSize, OptionalInt newMaxInitcodeSize, OptionalInt newEvmStackSize) {
        return new EvmConfiguration(this.jumpDestCacheWeightKB, this.worldUpdaterMode, newEvmStackSize.orElse(1024), newMaxCodeSize.isPresent() ? Optional.of(newMaxCodeSize.getAsInt()) : Optional.empty(), newMaxInitcodeSize.isPresent() ? Optional.of(newMaxInitcodeSize.getAsInt()) : Optional.empty());
    }

    public static enum WorldUpdaterMode {
        STACKED,
        JOURNALED;

    }
}

