/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ByteOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult byteSuccess = new Operation.OperationResult(3L, null);

    public ByteOperation(GasCalculator gasCalculator) {
        super(26, "BYTE", 2, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    private static Bytes getByte(Bytes seq, Bytes offset) {
        int size;
        Bytes trimmedOffset = offset.trimLeadingZeros();
        if (trimmedOffset.size() > 1) {
            return Bytes.EMPTY;
        }
        int index = trimmedOffset.toInt();
        int pos = index - 32 + (size = seq.size());
        if (pos >= size || pos < 0) {
            return Bytes.EMPTY;
        }
        byte b = seq.get(pos);
        return Bytes.of((byte[])new byte[]{b});
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return ByteOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value0 = frame.popStackItem();
        Bytes value1 = frame.popStackItem();
        Bytes result = ByteOperation.getByte(value1, value0);
        frame.pushStackItem(result);
        return byteSuccess;
    }
}

