/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.tracing;

import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.operation.SStoreOperation;
import org.hyperledger.besu.evm.tracing.OperationTracer;

public class EstimateGasOperationTracer
implements OperationTracer {
    private int maxDepth = 0;
    private long sStoreStipendNeeded = 0L;

    @Override
    public void tracePostExecution(MessageFrame frame, Operation.OperationResult operationResult) {
        Operation operation = frame.getCurrentOperation();
        if (operation instanceof SStoreOperation) {
            SStoreOperation sStoreOperation = (SStoreOperation)operation;
            if (this.sStoreStipendNeeded == 0L) {
                this.sStoreStipendNeeded = sStoreOperation.getMinimumGasRemaining();
            }
        }
        if (this.maxDepth < frame.getDepth()) {
            this.maxDepth = frame.getDepth();
        }
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public long getStipendNeeded() {
        return this.sStoreStipendNeeded;
    }
}

