/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.concurrent.framework.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.hiero.consensus.concurrent.framework.config.QueueThreadMetricsConfiguration;
import org.hiero.consensus.concurrent.framework.internal.AbstractQueueThreadConfiguration;
import org.hiero.consensus.concurrent.framework.internal.MeasuredBlockingQueue;

final class ThreadBuildingUtils {
    private ThreadBuildingUtils() {
    }

    static <T> BlockingQueue<T> getOrBuildQueue(@NonNull AbstractQueueThreadConfiguration<?, T> config) {
        QueueThreadMetricsConfiguration metricsConfig;
        BlockingQueue<T> queue = config.getQueue();
        if (queue == null) {
            queue = config.getCapacity() > 0 ? new LinkedBlockingQueue<T>(config.getCapacity()) : new LinkedBlockingQueue<T>();
        }
        if ((metricsConfig = config.getMetricsConfiguration()) != null && (metricsConfig.isMinSizeMetricEnabled() || metricsConfig.isMaxSizeMetricEnabled())) {
            queue = new MeasuredBlockingQueue<T>(queue, new MeasuredBlockingQueue.Config(metricsConfig.getMetrics(), metricsConfig.getCategory(), config.getThreadName()).withMaxSizeMetricEnabled(metricsConfig.isMaxSizeMetricEnabled()).withMinSizeMetricEnabled(metricsConfig.isMinSizeMetricEnabled()));
        }
        config.setQueue(queue);
        return queue;
    }
}

