/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.WrapsMessageDetails;
import com.hedera.hapi.node.state.history.WrapsMessageHistory;
import com.hedera.hapi.node.state.history.WrapsPhase;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.roster.impl.ActiveRosters;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface ReadableHistoryStore {
    @Nullable
    public Bytes getLedgerId();

    @NonNull
    public HistoryProofConstruction getConstructionOrThrow(long var1);

    @NonNull
    public HistoryProofConstruction getActiveConstruction();

    @NonNull
    public HistoryProofConstruction getNextConstruction();

    default public boolean isReadyToAdopt(@NonNull Bytes rosterHash) {
        HistoryProofConstruction construction = this.getNextConstruction();
        return construction.hasTargetProof() && construction.targetRosterHash().equals((Object)rosterHash);
    }

    @Nullable
    public HistoryProofConstruction getConstructionFor(@NonNull ActiveRosters var1);

    @NonNull
    public Map<Long, HistoryProofVote> getVotes(long var1, @NonNull Set<Long> var3);

    @NonNull
    public List<ProofKeyPublication> getProofKeyPublications(@NonNull Set<Long> var1);

    @NonNull
    public List<WrapsMessagePublication> getWrapsMessagePublications(long var1, @NonNull Set<Long> var3);

    public record WrapsMessagePublication(long nodeId, @NonNull Bytes message, @NonNull WrapsPhase phase, @NonNull Instant receiptTime) implements Comparable<WrapsMessagePublication>
    {
        public WrapsMessagePublication {
            Objects.requireNonNull(message);
            Objects.requireNonNull(phase);
            Objects.requireNonNull(receiptTime);
        }

        @Override
        public int compareTo(@NonNull WrapsMessagePublication that) {
            return Comparator.comparing(WrapsMessagePublication::receiptTime).compare(this, that);
        }

        public static List<WrapsMessagePublication> allFromHistory(long nodeId, @NonNull WrapsMessageHistory history) {
            return history.messages().stream().map(details -> new WrapsMessagePublication(nodeId, details.message(), details.phase(), HapiUtils.asInstant((Timestamp)details.publicationTimeOrThrow()))).toList();
        }

        public WrapsMessageDetails asWrapsMessageDetails() {
            return new WrapsMessageDetails(HapiUtils.asTimestamp((Instant)this.receiptTime), this.phase, this.message);
        }
    }

    public record ProofKeyPublication(long nodeId, @NonNull Bytes proofKey, @NonNull Instant adoptionTime) {
        public ProofKeyPublication {
            Objects.requireNonNull(proofKey);
            Objects.requireNonNull(adoptionTime);
        }
    }
}

