/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.query;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.util.FeeUtils;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.InsufficientBalanceException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.app.spi.workflows.QueryHandler;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.throttle.SynchronizedThrottleAccumulator;
import com.hedera.node.app.throttle.ThrottleUsage;
import com.hedera.node.app.util.ProtobufUtils;
import com.hedera.node.app.workflows.OpWorkflowMetrics;
import com.hedera.node.app.workflows.ingest.IngestChecker;
import com.hedera.node.app.workflows.ingest.SubmissionManager;
import com.hedera.node.app.workflows.query.QueryChecker;
import com.hedera.node.app.workflows.query.QueryContextImpl;
import com.hedera.node.app.workflows.query.QueryDispatcher;
import com.hedera.node.app.workflows.query.QueryWorkflow;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.FeesConfig;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.MalformedProtobufException;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.time.InstantSource;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class QueryWorkflowImpl
implements QueryWorkflow {
    private static final Logger logger = LogManager.getLogger(QueryWorkflowImpl.class);
    private static final EnumSet<ResponseType> UNSUPPORTED_RESPONSE_TYPES = EnumSet.of(ResponseType.ANSWER_STATE_PROOF, ResponseType.COST_ANSWER_STATE_PROOF);
    private static final List<HederaFunctionality> RESTRICTED_FUNCTIONALITIES = List.of(HederaFunctionality.NETWORK_GET_EXECUTION_TIME, HederaFunctionality.GET_ACCOUNT_DETAILS);
    private final Function<ResponseType, AutoCloseableWrapper<State>> stateAccessor;
    private final SubmissionManager submissionManager;
    private final QueryChecker queryChecker;
    private final IngestChecker ingestChecker;
    private final QueryDispatcher dispatcher;
    private final Codec<Query> queryParser;
    private final ConfigProvider configProvider;
    private final RecordCache recordCache;
    private final Authorizer authorizer;
    private final ExchangeRateManager exchangeRateManager;
    private final FeeManager feeManager;
    private final SynchronizedThrottleAccumulator synchronizedThrottleAccumulator;
    private final InstantSource instantSource;
    private final OpWorkflowMetrics workflowMetrics;
    private final boolean shouldCharge;

    @Inject
    public QueryWorkflowImpl(@NonNull Function<ResponseType, AutoCloseableWrapper<State>> stateAccessor, @NonNull SubmissionManager submissionManager, @NonNull QueryChecker queryChecker, @NonNull IngestChecker ingestChecker, @NonNull QueryDispatcher dispatcher, @NonNull Codec<Query> queryParser, @NonNull ConfigProvider configProvider, @NonNull RecordCache recordCache, @NonNull Authorizer authorizer, @NonNull ExchangeRateManager exchangeRateManager, @NonNull FeeManager feeManager, @NonNull SynchronizedThrottleAccumulator synchronizedThrottleAccumulator, @NonNull InstantSource instantSource, @NonNull OpWorkflowMetrics workflowMetrics, boolean shouldCharge) {
        this.stateAccessor = Objects.requireNonNull(stateAccessor, "stateAccessor must not be null");
        this.submissionManager = Objects.requireNonNull(submissionManager, "submissionManager must not be null");
        this.ingestChecker = Objects.requireNonNull(ingestChecker, "ingestChecker must not be null");
        this.queryChecker = Objects.requireNonNull(queryChecker, "queryChecker must not be null");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher must not be null");
        this.queryParser = Objects.requireNonNull(queryParser, "queryParser must not be null");
        this.configProvider = Objects.requireNonNull(configProvider, "configProvider must not be null");
        this.recordCache = Objects.requireNonNull(recordCache, "recordCache must not be null");
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager, "exchangeRateManager must not be null");
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer must not be null");
        this.feeManager = Objects.requireNonNull(feeManager, "feeManager must not be null");
        this.synchronizedThrottleAccumulator = Objects.requireNonNull(synchronizedThrottleAccumulator, "hapiThrottling must not be null");
        this.instantSource = Objects.requireNonNull(instantSource);
        this.workflowMetrics = Objects.requireNonNull(workflowMetrics);
        this.shouldCharge = shouldCharge;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleQuery(@NonNull Bytes requestBuffer, @NonNull BufferedData responseBuffer) {
        queryStart = System.nanoTime();
        Objects.requireNonNull(requestBuffer);
        Objects.requireNonNull(responseBuffer);
        consensusTime = this.instantSource.instant();
        query = this.parseQuery(requestBuffer);
        QueryWorkflowImpl.logger.debug("Received query: {}", (Object)query);
        function = QueryWorkflowImpl.functionOf(query);
        if (!HederaFunctionality.NONE.equals((Object)function)) {
            handler = this.dispatcher.getHandler(query);
            queryHeader = handler.extractHeader(query);
            if (queryHeader == null) {
                queryHeader = QueryHeader.DEFAULT;
            }
            responseType = queryHeader.responseType();
            QueryWorkflowImpl.logger.debug("Started answering a {} query of type {}", (Object)function, (Object)responseType);
            try {
                wrappedState = this.stateAccessor.apply(responseType);
                try {
                    this.ingestChecker.verifyPlatformActive();
                    if (QueryWorkflowImpl.UNSUPPORTED_RESPONSE_TYPES.contains(responseType)) {
                        throw new PreCheckException(ResponseCodeEnum.NOT_SUPPORTED);
                    }
                    state = (State)wrappedState.get();
                    storeFactory = new ReadableStoreFactory(state);
                    paymentRequired = handler.requiresNodePayment(responseType);
                    feeCalculator = this.feeManager.createFeeCalculator(function, consensusTime, storeFactory);
                    payerID = null;
                    if (this.shouldCharge && paymentRequired) {
                        configuration = this.configProvider.getConfiguration();
                        paymentBytes = ProtobufUtils.extractPaymentBytes(requestBuffer);
                        checkerResult = new IngestChecker.Result();
                        try {
                            this.ingestChecker.runAllChecks(state, paymentBytes, (Configuration)configuration, checkerResult);
                            txInfo = checkerResult.txnInfoOrThrow();
                            txBody = txInfo.txBody();
                            payerID = Objects.requireNonNull(checkerResult.txnInfoOrThrow().payerID());
                            context = new QueryContextImpl(state, storeFactory, query, (Configuration)configuration, this.recordCache, this.exchangeRateManager, feeCalculator, payerID);
                            if (this.authorizer.isSuperUser(payerID)) ** GOTO lbl62
                            this.ingestChecker.verifyReadyForTransactions();
                            this.queryChecker.validateCryptoTransfer(checkerResult.txnInfoOrThrow());
                            this.queryChecker.checkPermissions(payerID, function);
                            accountStore = storeFactory.getStore(ReadableAccountStore.class);
                            payer = accountStore.getAccountById(payerID);
                            if (payer == null) {
                                throw new PreCheckException(ResponseCodeEnum.PAYER_ACCOUNT_NOT_FOUND);
                            }
                            queryFees = 0L;
                            if (this.shouldUseSimpleFees(context)) {
                                queryFeeTinyCents = Objects.requireNonNull(this.feeManager.getSimpleFeeCalculator()).calculateQueryFee(context.query(), (QueryContext)context);
                                queryFees = FeeUtils.tinycentsToTinybars((long)queryFeeTinyCents, (com.hederahashgraph.api.proto.java.ExchangeRate)CommonPbjConverters.fromPbj((ExchangeRate)context.exchangeRateInfo().activeRate(consensusTime)));
                            } else {
                                queryFees = handler.computeFees((QueryContext)context).totalFee();
                            }
                            cryptoTransferTxnFee = this.queryChecker.estimateTxFees(storeFactory, consensusTime, checkerResult.txnInfoOrThrow(), payer.keyOrThrow(), (Configuration)configuration);
                            this.queryChecker.validateAccountBalances(accountStore, checkerResult.txnInfoOrThrow(), payer, queryFees, cryptoTransferTxnFee);
                            this.submissionManager.submit(txBody, txInfo.serializedSignedTxOrThrow());
                        }
                        catch (Exception e) {
                            checkerResult.throttleUsages().forEach((Consumer<ThrottleUsage>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, reclaimCapacity(), (Lcom/hedera/node/app/throttle/ThrottleUsage;)V)());
                            throw e;
                        }
                    } else {
                        if (QueryWorkflowImpl.RESTRICTED_FUNCTIONALITIES.contains(function)) {
                            throw new PreCheckException(ResponseCodeEnum.NOT_SUPPORTED);
                        }
                        context = new QueryContextImpl(state, storeFactory, query, (Configuration)this.configProvider.getConfiguration(), this.recordCache, this.exchangeRateManager, feeCalculator, null);
                    }
lbl62:
                    // 3 sources

                    handler.validate((QueryContext)context);
                    if (this.shouldCharge && this.synchronizedThrottleAccumulator.shouldThrottle(function, query, state, payerID)) {
                        this.workflowMetrics.incrementThrottled(function);
                        throw new PreCheckException(ResponseCodeEnum.BUSY);
                    }
                    if (handler.needsAnswerOnlyCost(responseType)) {
                        queryFees = 0L;
                        if (this.shouldUseSimpleFees(context)) {
                            queryFeeTinyCents = Objects.requireNonNull(this.feeManager.getSimpleFeeCalculator()).calculateQueryFee(context.query(), (QueryContext)context);
                            queryFees = FeeUtils.tinycentsToTinybars((long)queryFeeTinyCents, (com.hederahashgraph.api.proto.java.ExchangeRate)CommonPbjConverters.fromPbj((ExchangeRate)context.exchangeRateInfo().activeRate(consensusTime)));
                        } else {
                            queryFees = handler.computeFees((QueryContext)context).totalFee();
                        }
                        header = QueryWorkflowImpl.createResponseHeader(responseType, ResponseCodeEnum.OK, queryFees);
                        response = handler.createEmptyResponse(header);
                    } else {
                        header = QueryWorkflowImpl.createResponseHeader(responseType, ResponseCodeEnum.OK, 0L);
                        response = handler.findResponse((QueryContext)context, header);
                    }
                }
                finally {
                    if (wrappedState != null) {
                        wrappedState.close();
                    }
                }
            }
            catch (InsufficientBalanceException e) {
                response = QueryWorkflowImpl.createErrorResponse(handler, responseType, e.responseCode(), e.getEstimatedFee());
            }
            catch (PreCheckException e) {
                QueryWorkflowImpl.logger.debug("Query failed", (Throwable)e);
                response = QueryWorkflowImpl.createErrorResponse(handler, responseType, e.responseCode(), 0L);
            }
            catch (HandleException e) {
                QueryWorkflowImpl.logger.debug("Query failed", (Throwable)e);
                response = QueryWorkflowImpl.createErrorResponse(handler, responseType, e.getStatus(), 0L);
            }
            catch (Exception e) {
                QueryWorkflowImpl.logger.error("Unexpected exception while handling a query", (Throwable)e);
                response = QueryWorkflowImpl.createErrorResponse(handler, responseType, ResponseCodeEnum.FAIL_INVALID, 0L);
            }
        } else {
            throw new StatusRuntimeException(Status.INVALID_ARGUMENT);
        }
        try {
            Response.PROTOBUF.write((Object)response, (WritableSequentialData)responseBuffer);
            QueryWorkflowImpl.logger.debug("Finished handling a query request in Query workflow");
        }
        catch (IOException e) {
            QueryWorkflowImpl.logger.warn("Unexpected IO exception while writing protobuf", (Throwable)e);
            throw new StatusRuntimeException(Status.INTERNAL);
        }
        this.workflowMetrics.updateDuration(function, (int)(System.nanoTime() - queryStart));
    }

    private boolean shouldUseSimpleFees(QueryContext context) {
        if (!((FeesConfig)context.configuration().getConfigData(FeesConfig.class)).simpleFeesEnabled()) {
            return false;
        }
        return switch ((Query.QueryOneOfType)context.query().query().kind()) {
            case Query.QueryOneOfType.CONSENSUS_GET_TOPIC_INFO, Query.QueryOneOfType.SCHEDULE_GET_INFO, Query.QueryOneOfType.FILE_GET_CONTENTS, Query.QueryOneOfType.FILE_GET_INFO, Query.QueryOneOfType.CRYPTO_GET_INFO, Query.QueryOneOfType.CRYPTO_GET_ACCOUNT_RECORDS -> true;
            default -> false;
        };
    }

    private Query parseQuery(Bytes requestBuffer) {
        try {
            return (Query)this.queryParser.parseStrict(requestBuffer.toReadableSequentialData());
        }
        catch (ParseException e) {
            Throwable throwable = e.getCause();
            Objects.requireNonNull(throwable);
            Throwable throwable2 = throwable;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MalformedProtobufException.class, UnknownFieldException.class}, (Object)throwable2, n)) {
                case 0: {
                    MalformedProtobufException ignored = (MalformedProtobufException)throwable2;
                    break;
                }
                case 1: {
                    UnknownFieldException ignored = (UnknownFieldException)throwable2;
                    break;
                }
                default: {
                    logger.warn("Unexpected ParseException while parsing protobuf", (Throwable)e);
                }
            }
            throw new StatusRuntimeException(Status.INVALID_ARGUMENT);
        }
    }

    private static Response createErrorResponse(@NonNull QueryHandler handler, @NonNull ResponseType responseType, @NonNull ResponseCodeEnum responseCode, long fee) {
        ResponseHeader header = QueryWorkflowImpl.createResponseHeader(responseType, responseCode, fee);
        return handler.createEmptyResponse(header);
    }

    private static ResponseHeader createResponseHeader(@NonNull ResponseType type, @NonNull ResponseCodeEnum responseCode, long fee) {
        return ResponseHeader.newBuilder().responseType(type).nodeTransactionPrecheckCode(responseCode).cost(fee).build();
    }

    private static HederaFunctionality functionOf(@NonNull Query query) {
        try {
            return HapiUtils.functionOf((Query)query);
        }
        catch (UnknownHederaFunctionality e) {
            return HederaFunctionality.NONE;
        }
    }
}

