/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.balanceof;

import com.esaulpaugh.headlong.abi.Address;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.balanceof.BalanceOfCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BalanceOfTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod BALANCE_OF = SystemContractMethod.declare("balanceOf(address)", "(int)").withModifier(SystemContractMethod.Modifier.VIEW).withCategory(SystemContractMethod.Category.TOKEN_QUERY);

    @Inject
    public BalanceOfTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(BALANCE_OF);
    }

    public BalanceOfCall callFrom(@NonNull HtsCallAttempt attempt) {
        Address owner = (Address)BALANCE_OF.decodeCall(attempt.input().toArrayUnsafe()).get(0);
        return new BalanceOfCall(attempt.enhancement(), attempt.systemContractGasCalculator(), attempt.redirectToken(), owner);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(BALANCE_OF);
    }
}

