/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class MerkleLong
extends PartialMerkleLeaf
implements MerkleLeaf {
    public static final long CLASS_ID = 5101867068740213836L;
    private static final int CLASS_VERSION = 1;
    private long value;

    public MerkleLong() {
    }

    public MerkleLong(long value) {
        this.value = value;
    }

    protected MerkleLong(MerkleLong that) {
        super(that);
        this.value = that.value;
        that.setImmutable(true);
    }

    public long getValue() {
        return this.value;
    }

    public void increment() {
        this.throwIfImmutable();
        ++this.value;
        this.invalidateHash();
    }

    public void decrement() {
        this.throwIfImmutable();
        --this.value;
        this.invalidateHash();
    }

    @Override
    public MerkleLong copy() {
        this.throwIfImmutable();
        return new MerkleLong(this);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.value);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.value = in.readLong();
    }

    public long getClassId() {
        return 5101867068740213836L;
    }

    public int getVersion() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerkleLong)) {
            return false;
        }
        MerkleLong that = (MerkleLong)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("value", (Object)this.value).toString();
    }
}

