/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.metrics.api.ScopeConfig;
import io.helidon.metrics.api.ScopingConfigBlueprint;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.metrics.api.ScopingConfigBlueprint")
public interface ScopingConfig
extends ScopingConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ScopingConfig instance) {
        return (Builder)ScopingConfig.builder().from(instance);
    }

    public static ScopingConfig create(Config config) {
        return ((Builder)ScopingConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static ScopingConfig create(io.helidon.common.config.Config config) {
        return ScopingConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static ScopingConfig create() {
        return ScopingConfig.builder().buildPrototype();
    }

    @Override
    public Optional<String> defaultValue();

    @Override
    public Optional<String> tagName();

    @Override
    public Map<String, ScopeConfig> scopes();

    public static class Builder
    extends BuilderBase<Builder, ScopingConfig>
    implements io.helidon.common.Builder<Builder, ScopingConfig> {
        private Builder() {
        }

        public ScopingConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ScopingConfigImpl(this);
        }

        public ScopingConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ScopingConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Map<String, ScopeConfig> scopes = new LinkedHashMap<String, ScopeConfig>();
        private Config config;
        private String defaultValue = "application";
        private String tagName = "scope";

        protected BuilderBase() {
        }

        public BUILDER from(ScopingConfig prototype) {
            this.defaultValue(prototype.defaultValue());
            this.tagName(prototype.tagName());
            this.addScopes(prototype.scopes());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.defaultValue().ifPresent(this::defaultValue);
            builder.tagName().ifPresent(this::tagName);
            this.addScopes(builder.scopes);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("default").as(String.class).ifPresent(this::defaultValue);
            config.get("tag-name").as(String.class).ifPresent(this::tagName);
            config.get("scopes").asNodeList().ifPresent(nodes -> nodes.forEach(node -> this.scopes.put((String)node.get("name").asString().orElse((Object)node.name()), (ScopeConfig)node.as(ScopeConfig::create).get())));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDefaultValue() {
            this.defaultValue = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultValue(String defaultValue) {
            Objects.requireNonNull(defaultValue);
            this.defaultValue = defaultValue;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTagName() {
            this.tagName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tagName(String tagName) {
            Objects.requireNonNull(tagName);
            this.tagName = tagName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER scopes(Map<String, ? extends ScopeConfig> scopes) {
            Objects.requireNonNull(scopes);
            this.scopes.clear();
            this.scopes.putAll(scopes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScopes(Map<String, ? extends ScopeConfig> scopes) {
            Objects.requireNonNull(scopes);
            this.scopes.putAll(scopes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putScope(String key, ScopeConfig scope) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(scope);
            this.scopes.put(key, scope);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putScope(String key, Consumer<ScopeConfig.Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            ScopeConfig.Builder builder = ScopeConfig.builder();
            consumer.accept(builder);
            this.putScope(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> defaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }

        public Optional<String> tagName() {
            return Optional.ofNullable(this.tagName);
        }

        public Map<String, ScopeConfig> scopes() {
            return this.scopes;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ScopingConfigBuilder{defaultValue=" + this.defaultValue + ",tagName=" + this.tagName + ",scopes=" + String.valueOf(this.scopes) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER defaultValue(Optional<String> defaultValue) {
            Objects.requireNonNull(defaultValue);
            this.defaultValue = defaultValue.map(String.class::cast).orElse(this.defaultValue);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER tagName(Optional<String> tagName) {
            Objects.requireNonNull(tagName);
            this.tagName = tagName.map(String.class::cast).orElse(this.tagName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ScopingConfigImpl
        implements ScopingConfig {
            private final Map<String, ScopeConfig> scopes;
            private final Optional<String> defaultValue;
            private final Optional<String> tagName;

            protected ScopingConfigImpl(BuilderBase<?, ?> builder) {
                this.defaultValue = builder.defaultValue().map(Function.identity());
                this.tagName = builder.tagName().map(Function.identity());
                this.scopes = Collections.unmodifiableMap(new LinkedHashMap<String, ScopeConfig>(builder.scopes()));
            }

            @Override
            public Optional<String> defaultValue() {
                return this.defaultValue;
            }

            @Override
            public Optional<String> tagName() {
                return this.tagName;
            }

            @Override
            public Map<String, ScopeConfig> scopes() {
                return this.scopes;
            }

            public String toString() {
                return "ScopingConfig{defaultValue=" + String.valueOf(this.defaultValue) + ",tagName=" + String.valueOf(this.tagName) + ",scopes=" + String.valueOf(this.scopes) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ScopingConfig)) {
                    return false;
                }
                ScopingConfig other = (ScopingConfig)o;
                return Objects.equals(this.defaultValue, other.defaultValue()) && Objects.equals(this.tagName, other.tagName()) && Objects.equals(this.scopes, other.scopes());
            }

            public int hashCode() {
                return Objects.hash(this.defaultValue, this.tagName, this.scopes);
            }
        }
    }
}

