/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.token.CryptoDeleteAllowanceTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class CryptoDeleteAllowanceFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable FeeContext feeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        CryptoDeleteAllowanceTransactionBody op = txnBody.cryptoDeleteAllowanceOrThrow();
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CRYPTO_DELETE_ALLOWANCE);
        feeResult.addServiceFee(1L, serviceDef.baseFee());
        int totalAllowances = op.nftAllowances().size();
        if (totalAllowances > 0) {
            this.addExtraFee(feeResult, serviceDef, Extra.ALLOWANCES, feeSchedule, totalAllowances);
        }
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CRYPTO_DELETE_ALLOWANCE;
    }
}

