/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.common.EntityIDPair;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountFungibleTokenAllowance;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferStep;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdjustFungibleTokenChangesStep
extends BaseTokenHandler
implements TransferStep {
    private final List<TokenTransferList> tokenTransferLists;
    private final AccountID topLevelPayer;

    public AdjustFungibleTokenChangesStep(@NonNull List<TokenTransferList> tokenTransferLists, @NonNull AccountID topLevelPayer) {
        Objects.requireNonNull(tokenTransferLists);
        Objects.requireNonNull(topLevelPayer);
        this.tokenTransferLists = tokenTransferLists;
        this.topLevelPayer = topLevelPayer;
    }

    @Override
    public void doIn(@NonNull TransferContext transferContext) {
        Objects.requireNonNull(transferContext);
        HandleContext handleContext = transferContext.getHandleContext();
        StoreFactory storeFactory = handleContext.storeFactory();
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        LinkedHashMap<EntityIDPair, Long> aggregatedFungibleTokenChanges = new LinkedHashMap<EntityIDPair, Long>();
        LinkedHashMap<EntityIDPair, Long> allowanceTransfers = new LinkedHashMap<EntityIDPair, Long>();
        for (TokenTransferList transfers : this.tokenTransferLists) {
            TokenID tokenId = transfers.tokenOrThrow();
            Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
            if (token.tokenType() == TokenType.FUNGIBLE_COMMON && transfers.hasExpectedDecimals()) {
                HandleException.validateTrue((token.decimals() == transfers.expectedDecimalsOrThrow().intValue() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.UNEXPECTED_TOKEN_DECIMALS);
            }
            for (AccountAmount aa : transfers.transfers()) {
                HandleException.validateTrue((token.tokenType() == TokenType.FUNGIBLE_COMMON ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON);
                AccountID accountId = aa.accountIDOrThrow();
                TokenHandlerHelper.getIfUsable(accountId, accountStore, handleContext.expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
                EntityIDPair pair = new EntityIDPair(accountId, tokenId);
                AccountID accountID = aa.accountIDOrThrow();
                TokenRelation tokenRel = TokenHandlerHelper.getIfUsable(accountID, tokenId, tokenRelStore);
                this.validateNotFrozenAndKycOnRelation(tokenRel);
                aggregatedFungibleTokenChanges.merge(pair, aa.amount(), Long::sum);
                if (!aa.isApproval() || aa.amount() >= 0L) continue;
                allowanceTransfers.merge(pair, aa.amount(), Long::sum);
            }
        }
        this.modifyAggregatedAllowances(allowanceTransfers, accountStore, transferContext);
        this.modifyAggregatedTokenBalances(aggregatedFungibleTokenChanges, tokenRelStore, accountStore, transferContext.getAssessedCustomFees());
    }

    private void modifyAggregatedAllowances(@NonNull Map<EntityIDPair, Long> allowanceTransfers, @NonNull WritableAccountStore accountStore, @NonNull TransferContext transferContext) {
        for (Map.Entry<EntityIDPair, Long> entry : allowanceTransfers.entrySet()) {
            EntityIDPair atPair = entry.getKey();
            Long amount = entry.getValue();
            AccountID accountId = atPair.accountIdOrThrow();
            TokenID tokenId = atPair.tokenIdOrThrow();
            Account account = TokenHandlerHelper.getIfUsable(accountId, accountStore, transferContext.getHandleContext().expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
            Account.Builder accountCopy = account.copyBuilder();
            ArrayList<AccountFungibleTokenAllowance> tokenAllowances = new ArrayList<AccountFungibleTokenAllowance>(account.tokenAllowances());
            boolean haveExistingAllowance = false;
            for (int i = 0; i < tokenAllowances.size(); ++i) {
                AccountFungibleTokenAllowance allowance = (AccountFungibleTokenAllowance)tokenAllowances.get(i);
                AccountFungibleTokenAllowance.Builder allowanceCopy = allowance.copyBuilder();
                if (!this.topLevelPayer.equals((Object)allowance.spenderId()) || !tokenId.equals((Object)allowance.tokenId())) continue;
                haveExistingAllowance = true;
                long newAllowanceAmount = allowance.amount() + amount;
                HandleException.validateTrue((newAllowanceAmount >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.AMOUNT_EXCEEDS_ALLOWANCE);
                allowanceCopy.amount(newAllowanceAmount);
                if (newAllowanceAmount != 0L) {
                    tokenAllowances.set(i, allowanceCopy.build());
                    break;
                }
                tokenAllowances.remove(i);
                break;
            }
            HandleException.validateTrue((boolean)haveExistingAllowance, (ResponseCodeEnum)ResponseCodeEnum.SPENDER_DOES_NOT_HAVE_ALLOWANCE);
            accountCopy.tokenAllowances(tokenAllowances);
            accountStore.put(accountCopy.build());
        }
    }

    private void modifyAggregatedTokenBalances(@NonNull Map<EntityIDPair, Long> aggregatedFungibleTokenChanges, @NonNull WritableTokenRelationStore tokenRelStore, @NonNull WritableAccountStore accountStore, @NonNull List<AssessedCustomFee> assessedCustomFees) {
        for (Map.Entry<EntityIDPair, Long> entry : aggregatedFungibleTokenChanges.entrySet()) {
            EntityIDPair atPair = entry.getKey();
            Long amount = entry.getValue();
            TokenRelation rel = TokenHandlerHelper.getIfUsable(atPair.accountIdOrThrow(), atPair.tokenIdOrThrow(), tokenRelStore);
            Account account = Objects.requireNonNull(accountStore.get(atPair.accountIdOrThrow()));
            try {
                this.adjustBalance(rel, account, amount, tokenRelStore, accountStore);
            }
            catch (HandleException e) {
                if (e.getStatus() == ResponseCodeEnum.INSUFFICIENT_TOKEN_BALANCE && this.effectivePaymentWasMade(rel.accountIdOrThrow(), rel.tokenIdOrThrow(), assessedCustomFees)) {
                    throw new HandleException(ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE);
                }
                throw e;
            }
        }
    }

    private boolean effectivePaymentWasMade(@NonNull AccountID payer, @NonNull TokenID denom, @NonNull List<AssessedCustomFee> assessedCustomFees) {
        for (AssessedCustomFee fee : assessedCustomFees) {
            if (!denom.equals((Object)fee.tokenId()) || !fee.effectivePayerAccountId().contains(payer)) continue;
            return true;
        }
        return false;
    }
}

