/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.internal.network.codec;

import com.hedera.node.internal.network.BlockNodeConfig;
import com.hedera.node.internal.network.HelidonGrpcConfig;
import com.hedera.node.internal.network.HelidonHttpConfig;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class BlockNodeConfigJsonCodec
implements JsonCodec<BlockNodeConfig> {
    @NonNull
    public BlockNodeConfig parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            String temp_address = "";
            int temp_port = 0;
            int temp_priority = 0;
            Long temp_messageSizeSoftLimitBytes = null;
            Long temp_messageSizeHardLimitBytes = null;
            HelidonHttpConfig temp_client_http_config = null;
            HelidonGrpcConfig temp_client_grpc_config = null;
            block20: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "address": {
                        temp_address = JsonTools.unescape((String)JsonTools.checkSize((String)"address", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block20;
                    }
                    case "port": {
                        temp_port = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                    case "priority": {
                        temp_priority = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                    case "messageSizeSoftLimitBytes": {
                        temp_messageSizeSoftLimitBytes = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                    case "messageSizeHardLimitBytes": {
                        temp_messageSizeHardLimitBytes = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                    case "clientHttpConfig": {
                        temp_client_http_config = (HelidonHttpConfig)HelidonHttpConfig.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                    case "clientGrpcConfig": {
                        temp_client_grpc_config = (HelidonGrpcConfig)HelidonGrpcConfig.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new BlockNodeConfig(temp_address, temp_port, temp_priority, temp_messageSizeSoftLimitBytes, temp_messageSizeHardLimitBytes, temp_client_http_config, temp_client_grpc_config);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull BlockNodeConfig data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.address() != null && !data.address().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"address", (String)data.address()));
        }
        if (data.port() != 0) {
            fieldLines.add(JsonTools.field((String)"port", (int)data.port()));
        }
        if (data.priority() != 0) {
            fieldLines.add(JsonTools.field((String)"priority", (int)data.priority()));
        }
        if (data.messageSizeSoftLimitBytes() != null) {
            fieldLines.add(JsonTools.field((String)"messageSizeSoftLimitBytes", (Long)data.messageSizeSoftLimitBytes(), (boolean)true));
        }
        if (data.messageSizeHardLimitBytes() != null) {
            fieldLines.add(JsonTools.field((String)"messageSizeHardLimitBytes", (Long)data.messageSizeHardLimitBytes(), (boolean)true));
        }
        if (data.clientHttpConfig() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"clientHttpConfig", HelidonHttpConfig.JSON, (Object)data.clientHttpConfig()));
        }
        if (data.clientGrpcConfig() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"clientGrpcConfig", HelidonGrpcConfig.JSON, (Object)data.clientGrpcConfig()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

