/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.metrics;

import com.hedera.node.app.service.contract.impl.exec.metrics.CountAccumulateAverageMetricTriplet;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;

@Singleton
public class PrecompileOpsDurationMetric {
    private final Map<String, CountAccumulateAverageMetricTriplet> precompileOpsDurations = new ConcurrentHashMap<String, CountAccumulateAverageMetricTriplet>();
    private final Metrics metrics;

    public PrecompileOpsDurationMetric(@NonNull Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics);
    }

    public void recordPrecompileDuration(String precompileName, long durationNanos) {
        CountAccumulateAverageMetricTriplet metric = this.precompileOpsDurations.computeIfAbsent(precompileName, unused -> CountAccumulateAverageMetricTriplet.create(this.metrics, "app", String.format("%s:OpsDuration_ByPrecompile_%s", "SmartContractService", precompileName), "Ops duration of precompile " + precompileName + " in nanoseconds"));
        metric.recordObservation(durationNanos);
    }

    public double getAveragePrecompileDuration(String precompileName) {
        CountAccumulateAverageMetricTriplet metric = this.precompileOpsDurations.get(precompileName);
        return metric != null ? metric.average().get() : 0.0;
    }

    public long getPrecompileOpsDurationCount(String precompileName) {
        CountAccumulateAverageMetricTriplet metric = this.precompileOpsDurations.get(precompileName);
        return metric != null ? metric.counter().get() : 0L;
    }

    public long getPrecompileOpsTotalDuration(String precompileName) {
        CountAccumulateAverageMetricTriplet metric = this.precompileOpsDurations.get(precompileName);
        return metric != null ? metric.accumulator().get() : 0L;
    }
}

