/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.rules;

import com.hedera.hapi.node.state.roster.Roster;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.hiero.consensus.event.creator.impl.rules.WeightAndLag;
import org.hiero.consensus.model.node.NodeId;

public class SyncLagCalculator {
    private final Map<NodeId, Long> weightMap = new HashMap<NodeId, Long>();
    private final long otherNodesTotalWeight;
    private final Map<NodeId, WeightAndLag> consensusLag = new HashMap<NodeId, WeightAndLag>();
    private final NodeId selfId;

    public SyncLagCalculator(NodeId selfId, Roster roster) {
        this.selfId = selfId;
        this.otherNodesTotalWeight = roster.rosterEntries().stream().peek(entry -> this.weightMap.put(NodeId.of((long)entry.nodeId()), entry.weight())).peek(entry -> {
            if (selfId.id() != entry.nodeId()) {
                this.consensusLag.put(NodeId.of((long)entry.nodeId()), new WeightAndLag(entry.weight(), 0L));
            }
        }).mapToLong(entry -> {
            if (selfId.id() == entry.nodeId()) {
                return 0L;
            }
            return entry.weight();
        }).sum();
    }

    public void reportSyncLag(NodeId nodeId, long diff) {
        if (this.selfId.equals((Object)nodeId)) {
            throw new IllegalArgumentException("Reporting sync lag for self is illegal " + String.valueOf(nodeId) + " " + diff);
        }
        if (!this.weightMap.containsKey(nodeId)) {
            throw new IllegalArgumentException("Reporting sync lag for node " + String.valueOf(nodeId) + " which is not in the roster");
        }
        this.consensusLag.put(nodeId, new WeightAndLag(this.weightMap.get(nodeId), diff));
    }

    public double getSyncRoundLag() {
        double medianLag;
        WeightAndLag[] lagArray = (WeightAndLag[])this.consensusLag.values().toArray(WeightAndLag[]::new);
        if (this.otherNodesTotalWeight > 0L) {
            medianLag = lagArray[0].lag();
            Arrays.sort(lagArray, Comparator.comparing(WeightAndLag::lag));
            long correctedTotalWeight = this.otherNodesTotalWeight;
            long runningWeight = 0L;
            for (int i = 0; i < lagArray.length; ++i) {
                if ((runningWeight += lagArray[i].weight()) == correctedTotalWeight / 2L && i < lagArray.length - 2) {
                    medianLag = (double)(lagArray[i].lag() * lagArray[i].weight() + lagArray[i + 1].lag() * lagArray[i + 1].weight()) / ((double)lagArray[i].weight() + (double)lagArray[i + 1].weight());
                } else {
                    if (runningWeight <= correctedTotalWeight / 2L) continue;
                    medianLag = lagArray[i].lag();
                }
                break;
            }
        } else {
            medianLag = 0.0;
        }
        return Math.max(medianLag, 0.0);
    }
}

