/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.HttpException;
import io.helidon.service.registry.Service;
import io.helidon.webclient.api.ClientResponseTyped;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.RestClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service.Singleton
class DefaultErrorHandling
implements RestClient.ErrorHandling {
    private final List<RestClient.ErrorHandler> errorHandlers;

    DefaultErrorHandling(List<RestClient.ErrorHandler> errorHandlers) {
        ArrayList<RestClient.ErrorHandler> handlers = new ArrayList<RestClient.ErrorHandler>(errorHandlers);
        handlers.add(HttpErrorHandler.INSTANCE);
        this.errorHandlers = List.copyOf(handlers);
    }

    @Override
    public void handle(String uri, ClientRequestHeaders requestHeaders, HttpClientResponse response) {
        for (RestClient.ErrorHandler errorHandler : this.errorHandlers) {
            Optional<? extends RuntimeException> maybeException;
            if (!errorHandler.handles(uri, requestHeaders, response.status(), response.headers()) || !(maybeException = errorHandler.handleError(uri, requestHeaders, response)).isPresent()) continue;
            throw maybeException.get();
        }
    }

    @Override
    public void handle(String uri, ClientRequestHeaders requestHeaders, ClientResponseTyped<?> response, Class<?> type) {
        for (RestClient.ErrorHandler errorHandler : this.errorHandlers) {
            Optional<? extends RuntimeException> maybeException;
            if (!errorHandler.handles(uri, requestHeaders, response.status(), response.headers()) || !(maybeException = errorHandler.handleError(uri, requestHeaders, response, type)).isPresent()) continue;
            throw maybeException.get();
        }
    }

    private static class HttpErrorHandler
    implements RestClient.ErrorHandler {
        private static final HttpErrorHandler INSTANCE = new HttpErrorHandler();

        private HttpErrorHandler() {
        }

        @Override
        public Optional<? extends RuntimeException> handleError(String requestUri, ClientRequestHeaders requestHeaders, HttpClientResponse response) {
            return Optional.of(new HttpException("Failed when invoking a client call to " + requestUri + ", status: " + String.valueOf(response.status()), response.status()));
        }

        @Override
        public Optional<? extends RuntimeException> handleError(String requestUri, ClientRequestHeaders requestHeaders, ClientResponseTyped<?> response, Class<?> type) {
            return Optional.of(new HttpException("Failed when invoking a client call to " + requestUri + ", status: " + String.valueOf(response.status()), response.status()));
        }
    }
}

