/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming.config;

import com.hedera.node.internal.network.HelidonHttpConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.helidon.webclient.http2.Http2ClientProtocolConfig;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class BlockNodeHelidonHttpConfiguration {
    public static final BlockNodeHelidonHttpConfiguration DEFAULT = BlockNodeHelidonHttpConfiguration.newBuilder().build();
    private final Duration flowControlBlockTimeout;
    private final Integer initialWindowSize;
    private final Integer maxFrameSize;
    private final Long maxHeaderListSize;
    private final String name;
    private final Boolean ping;
    private final Duration pingTimeout;
    private final Boolean priorKnowledge;

    private BlockNodeHelidonHttpConfiguration(Builder builder) {
        this.flowControlBlockTimeout = builder.flowControlBlockTimeout;
        this.initialWindowSize = builder.initialWindowSize;
        this.maxFrameSize = builder.maxFrameSize;
        this.maxHeaderListSize = builder.maxHeaderListSize;
        this.name = builder.name;
        this.ping = builder.ping;
        this.pingTimeout = builder.pingTimeout;
        this.priorKnowledge = builder.priorKnowledge;
    }

    @NonNull
    public Optional<Duration> flowControlBlockTimeout() {
        return Optional.ofNullable(this.flowControlBlockTimeout);
    }

    @NonNull
    public Optional<Integer> initialWindowSize() {
        return Optional.ofNullable(this.initialWindowSize);
    }

    @NonNull
    public Optional<Integer> maxFrameSize() {
        return Optional.ofNullable(this.maxFrameSize);
    }

    @NonNull
    public Optional<Long> maxHeaderListSize() {
        return Optional.ofNullable(this.maxHeaderListSize);
    }

    @NonNull
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @NonNull
    public Optional<Boolean> ping() {
        return Optional.ofNullable(this.ping);
    }

    @NonNull
    public Optional<Duration> pingTimeout() {
        return Optional.ofNullable(this.pingTimeout);
    }

    @NonNull
    public Optional<Boolean> priorKnowledge() {
        return Optional.ofNullable(this.priorKnowledge);
    }

    @NonNull
    public Http2ClientProtocolConfig toHttp2ClientProtocolConfig() {
        Http2ClientProtocolConfig.Builder b = Http2ClientProtocolConfig.builder();
        this.flowControlBlockTimeout().ifPresent(arg_0 -> ((Http2ClientProtocolConfig.Builder)b).flowControlBlockTimeout(arg_0));
        this.initialWindowSize().ifPresent(arg_0 -> ((Http2ClientProtocolConfig.Builder)b).initialWindowSize(arg_0));
        this.maxFrameSize().ifPresent(arg_0 -> ((Http2ClientProtocolConfig.Builder)b).maxFrameSize(arg_0));
        this.maxHeaderListSize().ifPresent(arg_0 -> ((Http2ClientProtocolConfig.Builder)b).maxHeaderListSize(arg_0));
        this.name().ifPresent(arg_0 -> ((Http2ClientProtocolConfig.Builder)b).name(arg_0));
        this.ping().ifPresent(arg_0 -> ((Http2ClientProtocolConfig.Builder)b).ping(arg_0));
        this.pingTimeout().ifPresent(arg_0 -> ((Http2ClientProtocolConfig.Builder)b).pingTimeout(arg_0));
        this.priorKnowledge().ifPresent(arg_0 -> ((Http2ClientProtocolConfig.Builder)b).priorKnowledge(arg_0));
        return b.build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockNodeHelidonHttpConfiguration that = (BlockNodeHelidonHttpConfiguration)o;
        return Objects.equals(this.flowControlBlockTimeout, that.flowControlBlockTimeout) && Objects.equals(this.initialWindowSize, that.initialWindowSize) && Objects.equals(this.maxFrameSize, that.maxFrameSize) && Objects.equals(this.maxHeaderListSize, that.maxHeaderListSize) && Objects.equals(this.name, that.name) && Objects.equals(this.ping, that.ping) && Objects.equals(this.pingTimeout, that.pingTimeout) && Objects.equals(this.priorKnowledge, that.priorKnowledge);
    }

    public int hashCode() {
        return Objects.hash(this.flowControlBlockTimeout, this.initialWindowSize, this.maxFrameSize, this.maxHeaderListSize, this.name, this.ping, this.pingTimeout, this.priorKnowledge);
    }

    @NonNull
    public static BlockNodeHelidonHttpConfiguration from(@Nullable HelidonHttpConfig httpConfig) {
        if (httpConfig == null) {
            return DEFAULT;
        }
        Builder b = BlockNodeHelidonHttpConfiguration.newBuilder();
        String _flowControlBlockTimeout = httpConfig.flowControlBlockTimeout();
        if (_flowControlBlockTimeout != null && !_flowControlBlockTimeout.isBlank()) {
            b.flowControlBlockTimeout(Duration.parse(_flowControlBlockTimeout));
        }
        b.initialWindowSize(httpConfig.initialWindowSize());
        b.maxFrameSize(httpConfig.maxFrameSize());
        b.maxHeaderListSize(httpConfig.maxHeaderListSize());
        b.name(httpConfig.name());
        b.ping(httpConfig.ping());
        String _pingTimeout = httpConfig.pingTimeout();
        if (_pingTimeout != null && !_pingTimeout.isBlank()) {
            b.pingTimeout(Duration.parse(_pingTimeout));
        }
        b.priorKnowledge(httpConfig.priorKnowledge());
        return b.build();
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Duration flowControlBlockTimeout;
        private Integer initialWindowSize;
        private Integer maxFrameSize;
        private Long maxHeaderListSize;
        private String name;
        private Boolean ping;
        private Duration pingTimeout;
        private Boolean priorKnowledge;

        private Builder() {
        }

        @NonNull
        public Builder flowControlBlockTimeout(@Nullable Duration flowControlBlockTimeout) {
            this.flowControlBlockTimeout = flowControlBlockTimeout;
            return this;
        }

        @NonNull
        public Builder initialWindowSize(@Nullable Integer initialWindowSize) {
            this.initialWindowSize = initialWindowSize;
            return this;
        }

        @NonNull
        public Builder maxFrameSize(@Nullable Integer maxFrameSize) {
            this.maxFrameSize = maxFrameSize;
            return this;
        }

        @NonNull
        public Builder maxHeaderListSize(@Nullable Long maxHeaderListSize) {
            this.maxHeaderListSize = maxHeaderListSize;
            return this;
        }

        @NonNull
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder ping(@Nullable Boolean ping) {
            this.ping = ping;
            return this;
        }

        @NonNull
        public Builder pingTimeout(@Nullable Duration pingTimeout) {
            this.pingTimeout = pingTimeout;
            return this;
        }

        @NonNull
        public Builder priorKnowledge(@Nullable Boolean priorKnowledge) {
            this.priorKnowledge = priorKnowledge;
            return this;
        }

        public BlockNodeHelidonHttpConfiguration build() {
            return new BlockNodeHelidonHttpConfiguration(this);
        }
    }
}

