/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers.formats;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.records.SelfNodeAccountIdManager;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.NodesConfig;
import com.swirlds.common.io.utility.FileUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class SelfNodeAccountIdManagerImpl
implements SelfNodeAccountIdManager {
    private static final Logger logger = LogManager.getLogger(SelfNodeAccountIdManagerImpl.class);
    private final NodeInfo nodeInfo;
    private final Path filePath;

    @Inject
    public SelfNodeAccountIdManagerImpl(@NonNull ConfigProvider configProvider, @NonNull NetworkInfo networkInfo) {
        this.nodeInfo = networkInfo.selfNodeInfo();
        NodesConfig nodesConfig = (NodesConfig)configProvider.getConfiguration().getConfigData(NodesConfig.class);
        this.filePath = FileUtils.getAbsolutePath((String)nodesConfig.nodeGeneratedDir()).resolve(nodesConfig.nodeAccountIdFile());
    }

    public AccountID getSelfNodeAccountId() {
        try {
            if (!this.filePath.toFile().exists()) {
                this.writeAccountIdFile(this.nodeInfo.accountId());
            }
            String accountIdString = Files.readString(this.filePath);
            String[] parts = accountIdString.split("[.]");
            return AccountID.newBuilder().shardNum(Long.parseLong(parts[0])).realmNum(Long.parseLong(parts[1])).accountNum(Long.parseLong(parts[2])).build();
        }
        catch (IOException e) {
            logger.error("Failed to read node account id from {}", (Object)this.filePath, (Object)e);
            return this.nodeInfo.accountId();
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            logger.error("Failed to parse account id from {}", (Object)this.filePath, (Object)e);
            return this.nodeInfo.accountId();
        }
    }

    public void setSelfNodeAccountId(AccountID accountId) {
        try {
            this.writeAccountIdFile(accountId);
        }
        catch (IOException e) {
            logger.error("Failed to write node account id to {}", (Object)this.filePath, (Object)e);
        }
    }

    private void writeAccountIdFile(AccountID accountId) throws IOException {
        Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
        String content = accountId.shardNum() + "." + accountId.realmNum() + "." + accountId.accountNum();
        Files.writeString(this.filePath, (CharSequence)content, new OpenOption[0]);
        logger.info("Wrote node account id file at {}", (Object)this.filePath);
    }
}

