/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.history.codec;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.WrapsSigningState;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class HistoryProofConstructionJsonCodec
implements JsonCodec<HistoryProofConstruction> {
    public static final OneOf<HistoryProofConstruction.ProofStateOneOfType> PROOF_STATE_UNSET = new OneOf((Enum)HistoryProofConstruction.ProofStateOneOfType.UNSET, null);

    @NonNull
    public HistoryProofConstruction parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_construction_id = 0L;
            Bytes temp_source_roster_hash = Bytes.EMPTY;
            Bytes temp_target_roster_hash = Bytes.EMPTY;
            OneOf temp_proof_state = PROOF_STATE_UNSET;
            block22: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "constructionId": {
                        temp_construction_id = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                    case "sourceRosterHash": {
                        temp_source_roster_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"source_roster_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block22;
                    }
                    case "targetRosterHash": {
                        temp_target_roster_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"target_roster_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block22;
                    }
                    case "gracePeriodEndTime": {
                        temp_proof_state = new OneOf((Enum)HistoryProofConstruction.ProofStateOneOfType.GRACE_PERIOD_END_TIME, Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block22;
                    }
                    case "assemblyStartTime": {
                        temp_proof_state = new OneOf((Enum)HistoryProofConstruction.ProofStateOneOfType.ASSEMBLY_START_TIME, Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block22;
                    }
                    case "targetProof": {
                        temp_proof_state = new OneOf((Enum)HistoryProofConstruction.ProofStateOneOfType.TARGET_PROOF, HistoryProof.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block22;
                    }
                    case "failureReason": {
                        temp_proof_state = new OneOf((Enum)HistoryProofConstruction.ProofStateOneOfType.FAILURE_REASON, (Object)JsonTools.unescape((String)JsonTools.checkSize((String)"failure_reason", (String)kvPair.value().STRING().getText(), (int)maxSize)));
                        continue block22;
                    }
                    case "wrapsSigningState": {
                        temp_proof_state = new OneOf((Enum)HistoryProofConstruction.ProofStateOneOfType.WRAPS_SIGNING_STATE, WrapsSigningState.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block22;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new HistoryProofConstruction(temp_construction_id, temp_source_roster_hash, temp_target_roster_hash, temp_proof_state);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull HistoryProofConstruction data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.constructionId() != 0L) {
            fieldLines.add(JsonTools.field((String)"constructionId", (long)data.constructionId()));
        }
        if (data.sourceRosterHash() != Bytes.EMPTY && data.sourceRosterHash() != null && data.sourceRosterHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"sourceRosterHash", (Bytes)data.sourceRosterHash()));
        }
        if (data.targetRosterHash() != Bytes.EMPTY && data.targetRosterHash() != null && data.targetRosterHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"targetRosterHash", (Bytes)data.targetRosterHash()));
        }
        if (data.proofState().kind() == HistoryProofConstruction.ProofStateOneOfType.GRACE_PERIOD_END_TIME) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"gracePeriodEndTime", Timestamp.JSON, (Object)data.gracePeriodEndTime()));
        }
        if (data.proofState().kind() == HistoryProofConstruction.ProofStateOneOfType.ASSEMBLY_START_TIME) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"assemblyStartTime", Timestamp.JSON, (Object)data.assemblyStartTime()));
        }
        if (data.proofState().kind() == HistoryProofConstruction.ProofStateOneOfType.TARGET_PROOF) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"targetProof", HistoryProof.JSON, (Object)data.targetProof()));
        }
        if (data.proofState().kind() == HistoryProofConstruction.ProofStateOneOfType.FAILURE_REASON) {
            fieldLines.add(JsonTools.field((String)"failureReason", (String)data.failureReason()));
        }
        if (data.proofState().kind() == HistoryProofConstruction.ProofStateOneOfType.WRAPS_SIGNING_STATE) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"wrapsSigningState", WrapsSigningState.JSON, (Object)data.wrapsSigningState()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

