/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.infra;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.EthereumTransactionBody;
import com.hedera.hapi.node.state.file.File;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.hedera.node.app.service.contract.impl.hevm.HydratedEthTxData;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.file.ReadableFileStore;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

@Singleton
public class EthereumCallDataHydration {
    @Inject
    public EthereumCallDataHydration() {
    }

    public HydratedEthTxData tryToHydrate(@NonNull EthereumTransactionBody body, @NonNull ReadableFileStore fileStore, long firstUserEntityNum) {
        EthTxData ethTxData = EthTxData.populateEthTxData((byte[])body.ethereumData().toByteArray());
        if (ethTxData == null) {
            return HydratedEthTxData.failureFrom(ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION);
        }
        if (EthereumCallDataHydration.requiresHydration(body, ethTxData)) {
            byte[] callData;
            FileID callDataFileId = body.callDataOrThrow();
            if (callDataFileId.fileNum() < firstUserEntityNum) {
                return HydratedEthTxData.failureFrom(ResponseCodeEnum.INVALID_FILE_ID);
            }
            File callDataFile = fileStore.getFileLeaf(callDataFileId);
            if (callDataFile == null) {
                return HydratedEthTxData.failureFrom(ResponseCodeEnum.INVALID_FILE_ID);
            }
            if (callDataFile.deleted()) {
                return HydratedEthTxData.failureFrom(ResponseCodeEnum.FILE_DELETED);
            }
            try {
                callData = Hex.decode((byte[])ConversionUtils.removeIfAnyLeading0x(callDataFile.contents()));
            }
            catch (DecoderException ignore) {
                return HydratedEthTxData.failureFrom(ResponseCodeEnum.INVALID_FILE_ID);
            }
            if (callData.length == 0) {
                return HydratedEthTxData.failureFrom(ResponseCodeEnum.CONTRACT_FILE_EMPTY);
            }
            return HydratedEthTxData.successFrom(ethTxData.replaceCallData(callData), true);
        }
        return HydratedEthTxData.successFrom(ethTxData, false);
    }

    private static boolean requiresHydration(@NonNull EthereumTransactionBody body, @NonNull EthTxData ethTxData) {
        return body.hasCallData() && !ethTxData.hasCallData();
    }
}

