/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.cryptography.wraps.Proof;
import com.hedera.hapi.block.stream.AggregatedNodeSignatures;
import com.hedera.hapi.block.stream.ChainOfTrustProof;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.history.History;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.ProofKey;
import com.hedera.hapi.node.state.history.WrapsPhase;
import com.hedera.hapi.node.state.history.WrapsSigningState;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.history.HistoryLibrary;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.HistoryProver;
import com.hedera.node.app.history.impl.HistorySubmissions;
import com.hedera.node.app.history.impl.ProofControllers;
import com.hedera.node.app.history.impl.ProofKeysAccessorImpl;
import com.hedera.node.app.service.roster.impl.RosterTransitionWeights;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WrapsHistoryProver
implements HistoryProver {
    private static final Logger log = LogManager.getLogger(WrapsHistoryProver.class);
    private final long selfId;
    private final ProofKeysAccessorImpl.SchnorrKeyPair schnorrKeyPair;
    private final Map<Long, Bytes> proofKeys;
    private final RosterTransitionWeights weights;
    private final Executor executor;
    @Nullable
    private final HistoryProof sourceProof;
    private final HistoryLibrary historyLibrary;
    private final HistorySubmissions submissions;
    private final Map<WrapsPhase, SortedMap<Long, ReadableHistoryStore.WrapsMessagePublication>> phaseMessages = new EnumMap<WrapsPhase, SortedMap<Long, ReadableHistoryStore.WrapsMessagePublication>>(WrapsPhase.class);
    @Nullable
    private byte[] wrapsMessage;
    @Nullable
    private HistoryLibrary.AddressBook targetAddressBook;
    @Nullable
    private byte[] targetAddressBookHash;
    @Nullable
    private CompletableFuture<Void> r1Future;
    @Nullable
    private CompletableFuture<Void> r2Future;
    @Nullable
    private CompletableFuture<Void> r3Future;
    @Nullable
    private CompletableFuture<Void> voteFuture;
    @Nullable
    private byte[] entropy;
    private WrapsPhase wrapsPhase = WrapsPhase.R1;

    public WrapsHistoryProver(long selfId, @NonNull ProofKeysAccessorImpl.SchnorrKeyPair schnorrKeyPair, @Nullable HistoryProof sourceProof, @NonNull RosterTransitionWeights weights, @NonNull Map<Long, Bytes> proofKeys, @NonNull Executor executor, @NonNull HistoryLibrary historyLibrary, @NonNull HistorySubmissions submissions) {
        this.selfId = selfId;
        this.sourceProof = sourceProof;
        this.schnorrKeyPair = Objects.requireNonNull(schnorrKeyPair);
        this.weights = Objects.requireNonNull(weights);
        this.proofKeys = Objects.requireNonNull(proofKeys);
        this.executor = Objects.requireNonNull(executor);
        this.historyLibrary = Objects.requireNonNull(historyLibrary);
        this.submissions = Objects.requireNonNull(submissions);
    }

    @Override
    @NonNull
    public HistoryProver.Outcome advance(@NonNull Instant now, @NonNull HistoryProofConstruction construction, @NonNull Bytes targetMetadata, @NonNull Map<Long, Bytes> targetProofKeys, @NonNull TssConfig tssConfig, @Nullable Bytes ledgerId) {
        Objects.requireNonNull(now);
        Objects.requireNonNull(construction);
        Objects.requireNonNull(targetMetadata);
        Objects.requireNonNull(targetProofKeys);
        Objects.requireNonNull(tssConfig);
        if (ledgerId == null && this.sourceProof != null) {
            return new HistoryProver.Outcome.Failed("Only genesis WRAPS proofs are allowed to not have a ledger id");
        }
        WrapsSigningState state = construction.wrapsSigningStateOrElse(WrapsSigningState.DEFAULT);
        if (state.phase() != WrapsPhase.AGGREGATE && state.hasGracePeriodEndTime() && now.isAfter(HapiUtils.asInstant((Timestamp)state.gracePeriodEndTimeOrThrow()))) {
            Set<Long> submittingNodes = this.phaseMessages.get(state.phase()).keySet();
            List<Long> missingNodes = this.phaseMessages.get(WrapsPhase.R1).keySet().stream().filter(nodeId -> !submittingNodes.contains(nodeId)).toList();
            return new HistoryProver.Outcome.Failed("Still missing messages from R1 nodes " + String.valueOf(missingNodes) + " after end of grace period for phase " + String.valueOf(state.phase()));
        }
        if (this.wrapsMessage == null) {
            this.targetAddressBook = HistoryLibrary.AddressBook.from((SortedMap<Long, Long>)this.weights.targetNodeWeights(), nodeId -> targetProofKeys.getOrDefault(nodeId, HistoryLibrary.EMPTY_PUBLIC_KEY).toByteArray());
            this.wrapsMessage = this.historyLibrary.computeWrapsMessage(this.targetAddressBook, targetMetadata.toByteArray());
            this.targetAddressBookHash = this.historyLibrary.hashAddressBook(this.targetAddressBook);
        }
        this.publishIfNeeded(construction.constructionId(), state.phase(), targetMetadata, targetProofKeys, tssConfig, ledgerId);
        return HistoryProver.Outcome.InProgress.INSTANCE;
    }

    @Override
    public boolean addWrapsSigningMessage(long constructionId, @NonNull ReadableHistoryStore.WrapsMessagePublication publication, @NonNull WritableHistoryStore writableHistoryStore, @NonNull TssConfig tssConfig) {
        Objects.requireNonNull(publication);
        Objects.requireNonNull(writableHistoryStore);
        Objects.requireNonNull(tssConfig);
        return this.receiveWrapsSigningMessage(constructionId, publication, writableHistoryStore, tssConfig);
    }

    @Override
    public void replayWrapsSigningMessage(long constructionId, @NonNull ReadableHistoryStore.WrapsMessagePublication publication) {
        this.receiveWrapsSigningMessage(constructionId, publication, null, null);
    }

    @Override
    public boolean cancelPendingWork() {
        StringBuilder sb = new StringBuilder("Canceled work on WRAPS prover");
        boolean canceledSomething = false;
        if (this.r1Future != null && !this.r1Future.isDone()) {
            sb.append("\n  * In-flight R1 future");
            this.r1Future.cancel(true);
            canceledSomething = true;
        }
        if (this.r2Future != null && !this.r2Future.isDone()) {
            sb.append("\n  * In-flight R2 future");
            this.r2Future.cancel(true);
            canceledSomething = true;
        }
        if (this.r3Future != null && !this.r3Future.isDone()) {
            sb.append("\n  * In-flight R3 future");
            this.r3Future.cancel(true);
            canceledSomething = true;
        }
        if (this.voteFuture != null && !this.voteFuture.isDone()) {
            sb.append("\n  * In-flight vote future");
            this.voteFuture.cancel(true);
            canceledSomething = true;
        }
        if (canceledSomething) {
            log.info(sb.toString());
        }
        return canceledSomething;
    }

    private boolean receiveWrapsSigningMessage(long constructionId, @NonNull ReadableHistoryStore.WrapsMessagePublication publication, @Nullable WritableHistoryStore writableHistoryStore, @Nullable TssConfig tssConfig) {
        log.info("Received {} message from node{} for construction #{} (current phase={})", (Object)publication.phase(), (Object)publication.nodeId(), (Object)constructionId, (Object)this.wrapsPhase);
        if (publication.phase() != this.wrapsPhase) {
            return false;
        }
        WrapsPhase startPhase = this.wrapsPhase;
        SortedMap messages = this.phaseMessages.computeIfAbsent(this.wrapsPhase, p -> new TreeMap());
        if (this.wrapsPhase == WrapsPhase.R1) {
            if (messages.putIfAbsent(publication.nodeId(), publication) != null) {
                return false;
            }
            long r1Weight = messages.values().stream().mapToLong(p -> this.weights.sourceWeightOf(p.nodeId())).sum();
            log.info("Total weight of {} messages is {} (of {} total)", (Object)this.wrapsPhase, (Object)r1Weight, (Object)this.weights.sourceNodeWeights().values().stream().mapToLong(Long::longValue).sum());
            if (r1Weight >= RosterTransitionWeights.moreThanHalfOfTotal((Map)this.weights.sourceNodeWeights())) {
                if (writableHistoryStore != null && tssConfig != null) {
                    writableHistoryStore.advanceWrapsSigningPhase(constructionId, WrapsPhase.R2, publication.receiptTime().plus(tssConfig.wrapsMessageGracePeriod()));
                }
                this.wrapsPhase = WrapsPhase.R2;
            }
        } else if (this.wrapsPhase == WrapsPhase.R2) {
            Set<Long> r1Nodes = this.phaseMessages.get(WrapsPhase.R1).keySet();
            if (!r1Nodes.contains(publication.nodeId())) {
                return false;
            }
            if (messages.putIfAbsent(publication.nodeId(), publication) != null) {
                return false;
            }
            if (messages.keySet().containsAll(r1Nodes)) {
                if (writableHistoryStore != null && tssConfig != null) {
                    writableHistoryStore.advanceWrapsSigningPhase(constructionId, WrapsPhase.R3, publication.receiptTime().plus(tssConfig.wrapsMessageGracePeriod()));
                }
                this.wrapsPhase = WrapsPhase.R3;
            }
        } else {
            Set<Long> r1Nodes = this.phaseMessages.get(WrapsPhase.R1).keySet();
            if (!r1Nodes.contains(publication.nodeId())) {
                return false;
            }
            if (messages.putIfAbsent(publication.nodeId(), publication) != null) {
                return false;
            }
            if (messages.keySet().containsAll(r1Nodes)) {
                if (writableHistoryStore != null && tssConfig != null) {
                    writableHistoryStore.advanceWrapsSigningPhase(constructionId, WrapsPhase.AGGREGATE, null);
                }
                this.wrapsPhase = WrapsPhase.AGGREGATE;
            }
        }
        if (this.wrapsPhase != startPhase) {
            log.info("Advanced to {} for construction #{}", (Object)this.wrapsPhase, (Object)constructionId);
        }
        return true;
    }

    private void publishIfNeeded(long constructionId, @NonNull WrapsPhase phase, @NonNull Bytes targetMetadata, @NonNull Map<Long, Bytes> targetProofKeys, @NonNull TssConfig tssConfig, @Nullable Bytes ledgerId) {
        if (!(this.futureOf(phase) != null || phase != WrapsPhase.AGGREGATE && this.phaseMessages.getOrDefault(phase, Collections.emptySortedMap()).containsKey(this.selfId))) {
            log.info("Considering publication of WRAPS {} output on construction #{}", (Object)phase, (Object)constructionId);
            HistoryLibrary.AddressBook book = Objects.requireNonNull(this.targetAddressBook);
            byte[] bookHash = Objects.requireNonNull(this.targetAddressBookHash);
            List<ProofKey> proofKeyList = this.proofKeyListFrom(targetProofKeys);
            this.consumerOf(phase).accept((CompletableFuture<Void>)((CompletableFuture)this.outputFuture(phase, tssConfig, ledgerId, book, targetMetadata).thenAcceptAsync(output -> {
                if (output == null) {
                    if (phase == WrapsPhase.R1 || phase == WrapsPhase.AGGREGATE) {
                        log.warn("Got null output for {} phase, skipping publication", (Object)phase);
                    }
                    return;
                }
                WrapsPhaseOutput wrapsPhaseOutput = output;
                Objects.requireNonNull(wrapsPhaseOutput);
                WrapsPhaseOutput selector0$temp = wrapsPhaseOutput;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MessagePhaseOutput.class, AggregatePhaseOutput.class, ProofPhaseOutput.class}, (Object)selector0$temp, index$1)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        MessagePhaseOutput messageOutput = (MessagePhaseOutput)selector0$temp;
                        Bytes wrapsMessage = Bytes.wrap((byte[])messageOutput.message());
                        this.submissions.submitWrapsSigningMessage(phase, wrapsMessage, constructionId).join();
                        break;
                    }
                    case 1: {
                        AggregatePhaseOutput aggregatePhaseOutput = (AggregatePhaseOutput)selector0$temp;
                        AggregatedNodeSignatures nonRecursiveProof = new AggregatedNodeSignatures(Bytes.wrap((byte[])aggregatePhaseOutput.signature()), new ArrayList<Long>(this.phaseMessages.get(WrapsPhase.R1).keySet()));
                        this.submissions.submitProofVote(constructionId, HistoryProof.newBuilder().targetProofKeys(proofKeyList).targetHistory(new History(Bytes.wrap((byte[])bookHash), targetMetadata)).chainOfTrustProof(ChainOfTrustProof.newBuilder().aggregatedNodeSignatures(nonRecursiveProof)).build()).join();
                        break;
                    }
                    case 2: {
                        ProofPhaseOutput proofOutput = (ProofPhaseOutput)selector0$temp;
                        Bytes recursiveProof = Bytes.wrap((byte[])proofOutput.compressed());
                        Bytes uncompressedProof = Bytes.wrap((byte[])proofOutput.uncompressed());
                        this.submissions.submitProofVote(constructionId, HistoryProof.newBuilder().targetProofKeys(proofKeyList).targetHistory(new History(Bytes.wrap((byte[])bookHash), targetMetadata)).chainOfTrustProof(ChainOfTrustProof.newBuilder().wrapsProof(recursiveProof)).uncompressedWrapsProof(uncompressedProof).build()).join();
                    }
                }
            }, this.executor)).exceptionally(e -> {
                log.error("Failed to publish WRAPS {} message for construction #{}", (Object)phase, (Object)constructionId, e);
                return null;
            }));
        }
    }

    private CompletableFuture<WrapsPhaseOutput> outputFuture(@NonNull WrapsPhase phase, @NonNull TssConfig tssConfig, @Nullable Bytes ledgerId, @NonNull HistoryLibrary.AddressBook targetBook, @NonNull Bytes targetMetadata) {
        byte[] message = Objects.requireNonNull(this.wrapsMessage);
        return CompletableFuture.supplyAsync(() -> switch (phase) {
            default -> throw new MatchException(null, null);
            case WrapsPhase.R1 -> {
                if (this.entropy == null) {
                    this.entropy = new byte[32];
                    new SecureRandom().nextBytes(this.entropy);
                    yield new MessagePhaseOutput(this.historyLibrary.runWrapsPhaseR1(this.entropy, message, this.schnorrKeyPair.privateKey().toByteArray()));
                }
                yield null;
            }
            case WrapsPhase.R2 -> {
                if (this.entropy != null && this.phaseMessages.get(WrapsPhase.R1).containsKey(this.selfId)) {
                    yield new MessagePhaseOutput(this.historyLibrary.runWrapsPhaseR2(this.entropy, message, this.rawMessagesFor(WrapsPhase.R1), this.schnorrKeyPair.privateKey().toByteArray(), this.publicKeysForR1()));
                }
                yield null;
            }
            case WrapsPhase.R3 -> {
                if (this.entropy != null && this.phaseMessages.get(WrapsPhase.R1).containsKey(this.selfId)) {
                    yield new MessagePhaseOutput(this.historyLibrary.runWrapsPhaseR3(this.entropy, message, this.rawMessagesFor(WrapsPhase.R1), this.rawMessagesFor(WrapsPhase.R2), this.schnorrKeyPair.privateKey().toByteArray(), this.publicKeysForR1()));
                }
                yield null;
            }
            case WrapsPhase.AGGREGATE -> {
                if (this.entropy != null) {
                    byte[] signature = this.historyLibrary.runAggregationPhase(message, this.rawMessagesFor(WrapsPhase.R1), this.rawMessagesFor(WrapsPhase.R2), this.rawMessagesFor(WrapsPhase.R3), this.publicKeysForR1());
                    if (this.sourceProof == null || !tssConfig.wrapsEnabled()) {
                        yield new AggregatePhaseOutput(signature, this.phaseMessages.get(WrapsPhase.R1).keySet().stream().toList());
                    }
                    Proof proof = !ProofControllers.isWrapsExtensible(this.sourceProof) ? this.historyLibrary.constructGenesisWrapsProof(Objects.requireNonNull(ledgerId).toByteArray(), signature, this.phaseMessages.get(WrapsPhase.R1).keySet(), targetBook) : new Proof(this.sourceProof.uncompressedWrapsProof().toByteArray(), this.sourceProof.chainOfTrustProofOrThrow().wrapsProofOrThrow().toByteArray());
                    HistoryLibrary.AddressBook sourceBook = HistoryLibrary.AddressBook.from((SortedMap<Long, Long>)this.weights.sourceNodeWeights(), nodeId -> this.proofKeys.getOrDefault(nodeId, HistoryLibrary.EMPTY_PUBLIC_KEY).toByteArray());
                    proof = this.historyLibrary.constructIncrementalWrapsProof(Objects.requireNonNull(ledgerId).toByteArray(), proof.uncompressed(), sourceBook, targetBook, targetMetadata.toByteArray(), signature, this.phaseMessages.get(WrapsPhase.R1).keySet());
                    yield new ProofPhaseOutput(proof.compressed(), proof.uncompressed());
                }
                yield null;
            }
        }, this.executor);
    }

    private byte[][] publicKeysForR1() {
        return (byte[][])this.phaseMessages.get(WrapsPhase.R1).keySet().stream().map(nodeId -> this.proofKeys.get(nodeId).toByteArray()).toArray(x$0 -> new byte[x$0][]);
    }

    private byte[][] rawMessagesFor(@NonNull WrapsPhase phase) {
        return (byte[][])this.phaseMessages.get(phase).values().stream().map(ReadableHistoryStore.WrapsMessagePublication::message).map(Bytes::toByteArray).toArray(x$0 -> new byte[x$0][]);
    }

    private CompletableFuture<Void> futureOf(@NonNull WrapsPhase phase) {
        return switch (phase) {
            default -> throw new MatchException(null, null);
            case WrapsPhase.R1 -> this.r1Future;
            case WrapsPhase.R2 -> this.r2Future;
            case WrapsPhase.R3 -> this.r3Future;
            case WrapsPhase.AGGREGATE -> this.voteFuture;
        };
    }

    private Consumer<CompletableFuture<Void>> consumerOf(@NonNull WrapsPhase phase) {
        return switch (phase) {
            default -> throw new MatchException(null, null);
            case WrapsPhase.R1 -> f -> {
                this.r1Future = f;
            };
            case WrapsPhase.R2 -> f -> {
                this.r2Future = f;
            };
            case WrapsPhase.R3 -> f -> {
                this.r3Future = f;
            };
            case WrapsPhase.AGGREGATE -> f -> {
                this.voteFuture = f;
            };
        };
    }

    private record MessagePhaseOutput(byte[] message) implements WrapsPhaseOutput
    {
    }

    private record AggregatePhaseOutput(byte[] signature, List<Long> nodeIds) implements WrapsPhaseOutput
    {
    }

    private record ProofPhaseOutput(byte[] compressed, byte[] uncompressed) implements WrapsPhaseOutput
    {
    }

    private static sealed interface WrapsPhaseOutput
    permits MessagePhaseOutput, ProofPhaseOutput, AggregatePhaseOutput {
    }
}

