/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.node.app.fees.congestion.ThrottleMultiplier;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.throttle.NetworkUtilizationManager;
import com.hedera.node.app.throttle.NetworkUtilizationManagerImpl;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.app.throttle.ThrottleMetrics;
import com.hedera.node.app.throttle.annotations.BackendThrottle;
import com.hedera.node.app.throttle.annotations.CryptoTransferThrottleMultiplier;
import com.hedera.node.app.throttle.annotations.GasThrottleMultiplier;
import com.hedera.node.app.throttle.annotations.IngestThrottle;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.FeesConfig;
import com.swirlds.metrics.api.Metrics;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.IntSupplier;
import javax.inject.Singleton;

@Module
public interface ThrottleServiceModule {
    @Binds
    @Singleton
    public NetworkUtilizationManager provideNetworkUtilizationManager(NetworkUtilizationManagerImpl var1);

    @Provides
    @Singleton
    @IngestThrottle
    public static ThrottleAccumulator provideIngestThrottleAccumulator(@NonNull NetworkInfo networkInfo, @NonNull ConfigProvider configProvider, @NonNull Metrics metrics) {
        ThrottleMetrics throttleMetrics = new ThrottleMetrics(metrics, ThrottleAccumulator.ThrottleType.FRONTEND_THROTTLE);
        IntSupplier frontendThrottleSplit = () -> networkInfo.addressBook().size();
        return new ThrottleAccumulator(frontendThrottleSplit, () -> ((ConfigProvider)configProvider).getConfiguration(), ThrottleAccumulator.ThrottleType.FRONTEND_THROTTLE, throttleMetrics, ThrottleAccumulator.Verbose.YES);
    }

    @Provides
    @Singleton
    @CryptoTransferThrottleMultiplier
    public static ThrottleMultiplier provideCryptoTransferThrottleMultiplier(ConfigProvider configProvider, @BackendThrottle ThrottleAccumulator backendThrottle) {
        return new ThrottleMultiplier("logical TPS", "TPS", "CryptoTransfer throughput", () -> ((FeesConfig)configProvider.getConfiguration().getConfigData(FeesConfig.class)).minCongestionPeriod(), () -> ((FeesConfig)configProvider.getConfiguration().getConfigData(FeesConfig.class)).percentCongestionMultipliers(), () -> backendThrottle.activeThrottlesFor(HederaFunctionality.CRYPTO_TRANSFER));
    }

    @Provides
    @Singleton
    @GasThrottleMultiplier
    public static ThrottleMultiplier provideGasThrottleMultiplier(ConfigProvider configProvider, @BackendThrottle ThrottleAccumulator backendThrottle) {
        return new ThrottleMultiplier("EVM gas/sec", "gas/sec", "EVM utilization", () -> ((FeesConfig)configProvider.getConfiguration().getConfigData(FeesConfig.class)).minCongestionPeriod(), () -> ((FeesConfig)configProvider.getConfiguration().getConfigData(FeesConfig.class)).percentCongestionMultipliers(), () -> List.of(backendThrottle.gasLimitThrottle()));
    }
}

