/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.ReadableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableStakingInfoStore;
import com.hedera.node.app.service.token.impl.handlers.staking.StakeIdChangeType;
import com.hedera.node.app.service.token.impl.handlers.staking.StakeInfoHelper;
import com.hedera.node.app.service.token.impl.handlers.staking.StakePeriodManager;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingRewardsDistributor;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingRewardsHandler;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingRewardsHelper;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingUtilities;
import com.hedera.node.app.service.token.records.FinalizeContext;
import com.hedera.node.app.spi.workflows.record.DeleteCapableTransactionStreamBuilder;
import com.hedera.node.config.data.AccountsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class StakingRewardsHandlerImpl
implements StakingRewardsHandler {
    private static final Logger log = LogManager.getLogger(StakingRewardsHandlerImpl.class);
    private final StakingRewardsDistributor rewardsPayer;
    private final StakePeriodManager stakePeriodManager;
    private final StakeInfoHelper stakeInfoHelper;
    private final EntityIdFactory entityIdFactory;

    @Inject
    public StakingRewardsHandlerImpl(@NonNull StakingRewardsDistributor rewardsPayer, @NonNull StakePeriodManager stakePeriodManager, @NonNull StakeInfoHelper stakeInfoHelper, @NonNull EntityIdFactory entityIdFactory) {
        this.rewardsPayer = Objects.requireNonNull(rewardsPayer);
        this.stakePeriodManager = Objects.requireNonNull(stakePeriodManager);
        this.stakeInfoHelper = Objects.requireNonNull(stakeInfoHelper);
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    @Override
    public Map<AccountID, Long> applyStakingRewards(@NonNull FinalizeContext context, @NonNull Set<AccountID> explicitRewardReceivers, @NonNull Map<AccountID, Long> prePaidRewards) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(explicitRewardReceivers);
        WritableAccountStore writableStore = (WritableAccountStore)context.writableStore(WritableAccountStore.class);
        WritableNetworkStakingRewardsStore stakingRewardsStore = (WritableNetworkStakingRewardsStore)context.writableStore(WritableNetworkStakingRewardsStore.class);
        WritableStakingInfoStore stakingInfoStore = (WritableStakingInfoStore)context.writableStore(WritableStakingInfoStore.class);
        AccountsConfig accountsConfig = (AccountsConfig)context.configuration().getConfigData(AccountsConfig.class);
        AccountID stakingRewardAccountId = this.entityIdFactory.newAccountId(accountsConfig.stakingRewardAccount());
        Instant consensusNow = context.consensusTime();
        Set<AccountID> stakedToMeRewardReceivers = this.getStakedToMeRewardReceivers(writableStore);
        Set<AccountID> rewardReceivers = StakingRewardsHelper.getAllRewardReceivers(writableStore, stakedToMeRewardReceivers, explicitRewardReceivers);
        rewardReceivers.removeAll(prePaidRewards.keySet());
        DeleteCapableTransactionStreamBuilder recordBuilder = (DeleteCapableTransactionStreamBuilder)context.userTransactionRecordBuilder(DeleteCapableTransactionStreamBuilder.class);
        Map<AccountID, Long> rewardsPaid = this.rewardsPayer.payRewardsIfPending(rewardReceivers, stakingRewardAccountId, writableStore, stakingRewardsStore, stakingInfoStore, consensusNow, recordBuilder);
        this.decreaseStakeRewardAccountBalance(rewardsPaid, stakingRewardAccountId, writableStore);
        if (!context.isScheduleDispatch()) {
            rewardReceivers.addAll(prePaidRewards.keySet());
            rewardsPaid.putAll(prePaidRewards);
            this.adjustStakedToMeForAccountStakees(writableStore);
            this.adjustStakeMetadata(writableStore, stakingInfoStore, stakingRewardsStore, consensusNow, rewardsPaid, rewardReceivers);
            if (!prePaidRewards.isEmpty()) {
                for (AccountID accountID : prePaidRewards.keySet()) {
                    rewardsPaid.remove(accountID);
                }
            }
        }
        return rewardsPaid;
    }

    public void adjustStakedToMeForAccountStakees(@NonNull WritableAccountStore writableStore) {
        ArrayList<AccountID> modifiedAccountIds = new ArrayList<AccountID>(writableStore.modifiedAccountsInState());
        for (AccountID id : modifiedAccountIds) {
            Account modifiedAccount;
            Account originalAccount = writableStore.getOriginalValue(id);
            StakeIdChangeType scenario = StakeIdChangeType.forCase(originalAccount, modifiedAccount = Objects.requireNonNull(writableStore.get(id)));
            if (scenario.equals((Object)StakeIdChangeType.FROM_ACCOUNT_TO_ACCOUNT) && Objects.requireNonNull(originalAccount).stakedAccountIdOrThrow().equals((Object)modifiedAccount.stakedAccountId())) {
                long roundedFinalBalance = StakingUtilities.roundedToHbar(modifiedAccount.tinybarBalance());
                long roundedInitialBalance = StakingUtilities.roundedToHbar(originalAccount.tinybarBalance());
                long delta = roundedFinalBalance - roundedInitialBalance;
                if (modifiedAccount.tinybarBalance() == originalAccount.tinybarBalance()) continue;
                this.updateStakedToMeFor(modifiedAccount.stakedAccountId(), delta, writableStore);
                continue;
            }
            if (scenario.withdrawsFromAccount()) {
                AccountID curStakedAccountId = Objects.requireNonNull(originalAccount).stakedAccountId();
                long roundedInitialBalance = StakingUtilities.roundedToHbar(originalAccount.tinybarBalance());
                this.updateStakedToMeFor(curStakedAccountId, -roundedInitialBalance, writableStore);
            }
            if (!scenario.awardsToAccount()) continue;
            AccountID newStakedAccountId = modifiedAccount.stakedAccountId();
            long balance = modifiedAccount.tinybarBalance();
            long roundedFinalBalance = StakingUtilities.roundedToHbar(balance);
            this.updateStakedToMeFor(newStakedAccountId, roundedFinalBalance, writableStore);
        }
    }

    public Set<AccountID> getStakedToMeRewardReceivers(@NonNull WritableAccountStore writableStore) {
        ArrayList<AccountID> modifiedAccounts = new ArrayList<AccountID>(writableStore.modifiedAccountsInState());
        Set<AccountID> specialRewardReceivers = null;
        for (AccountID id : modifiedAccounts) {
            Account modifiedAccount;
            Account originalAccount = writableStore.getOriginalValue(id);
            StakeIdChangeType scenario = StakeIdChangeType.forCase(originalAccount, modifiedAccount = Objects.requireNonNull(writableStore.get(id)));
            if (scenario.equals((Object)StakeIdChangeType.FROM_ACCOUNT_TO_ACCOUNT) && Objects.requireNonNull(originalAccount).stakedAccountIdOrThrow().equals((Object)modifiedAccount.stakedAccountId())) {
                if (modifiedAccount.tinybarBalance() == originalAccount.tinybarBalance()) continue;
                specialRewardReceivers = this.updateSpecialRewardReceivers(specialRewardReceivers, modifiedAccount, writableStore);
                continue;
            }
            if (scenario.withdrawsFromAccount()) {
                specialRewardReceivers = this.updateSpecialRewardReceivers(specialRewardReceivers, originalAccount, writableStore);
            }
            if (!scenario.awardsToAccount()) continue;
            specialRewardReceivers = this.updateSpecialRewardReceivers(specialRewardReceivers, modifiedAccount, writableStore);
        }
        return specialRewardReceivers == null ? Collections.emptySet() : specialRewardReceivers;
    }

    @NonNull
    private Set<AccountID> updateSpecialRewardReceivers(@Nullable Set<AccountID> specialRewardReceivers, @NonNull Account account, @NonNull WritableAccountStore accountStore) {
        LinkedHashSet<AccountID> updatedSpecialRewardReceivers = specialRewardReceivers == null ? new LinkedHashSet<AccountID>() : specialRewardReceivers;
        AccountID stakedAccountId = account.stakedAccountId();
        Account stakedAccount = accountStore.getOriginalValue(stakedAccountId);
        if (stakedAccount != null && stakedAccount.hasStakedNodeId()) {
            updatedSpecialRewardReceivers.add(stakedAccountId);
        }
        return updatedSpecialRewardReceivers;
    }

    private void adjustStakeMetadata(WritableAccountStore writableStore, WritableStakingInfoStore stakingInfoStore, WritableNetworkStakingRewardsStore stakingRewardStore, Instant consensusNow, Map<AccountID, Long> paidRewards, Set<AccountID> rewardReceivers) {
        Set<AccountID> accountsToBeReviewed = writableStore.modifiedAccountsInState();
        if (!writableStore.modifiedAccountsInState().containsAll(rewardReceivers)) {
            accountsToBeReviewed = new LinkedHashSet<AccountID>(writableStore.modifiedAccountsInState());
            accountsToBeReviewed.addAll(rewardReceivers);
        }
        for (AccountID id : accountsToBeReviewed) {
            boolean wasRewarded;
            long stakePeriodStart;
            Account originalAccount = writableStore.getOriginalValue(id);
            Account modifiedAccount = writableStore.get(id);
            StakeIdChangeType scenario = StakeIdChangeType.forCase(originalAccount, modifiedAccount);
            boolean containStakeMetaChanges = StakingUtilities.hasStakeMetaChanges(originalAccount, modifiedAccount);
            if (scenario.withdrawsFromNode() || scenario.awardsToNode()) {
                this.adjustNodeStakes(scenario, originalAccount, modifiedAccount, stakingInfoStore, stakingRewardStore, containStakeMetaChanges, consensusNow);
            }
            boolean rewardSituation = paidRewards.containsKey(id);
            Long reward = paidRewards.getOrDefault(id, 0L);
            if (containStakeMetaChanges) {
                Account.Builder copy = modifiedAccount.copyBuilder();
                copy.stakeAtStartOfLastRewardedPeriod(-1L);
                writableStore.put(copy.build());
            } else if (this.shouldUpdateStakeAtStartOfLastRewardPeriod(originalAccount, rewardSituation, reward, stakingRewardStore, consensusNow)) {
                Account.Builder copy = modifiedAccount.copyBuilder();
                copy.stakeAtStartOfLastRewardedPeriod(StakingUtilities.roundedToHbar(StakingUtilities.totalStake(originalAccount)));
                writableStore.put(copy.build());
            }
            if ((stakePeriodStart = this.stakePeriodManager.startUpdateFor(originalAccount, modifiedAccount = writableStore.get(id), wasRewarded = rewardSituation && (reward > 0L || reward == 0L && this.earnedZeroRewardsBecauseOfZeroStake(originalAccount, stakingRewardStore, consensusNow)), containStakeMetaChanges)) == -1L) continue;
            Account.Builder copy = modifiedAccount.copyBuilder();
            copy.stakePeriodStart(stakePeriodStart);
            writableStore.put(copy.build());
        }
    }

    private boolean earnedZeroRewardsBecauseOfZeroStake(@NonNull Account account, @NonNull ReadableNetworkStakingRewardsStore stakingRewardStore, @NonNull Instant consensusNow) {
        return Objects.requireNonNull(account).stakePeriodStart() < this.stakePeriodManager.firstNonRewardableStakePeriod(stakingRewardStore);
    }

    private void adjustNodeStakes(StakeIdChangeType scenario, Account originalAccount, Account modifiedAccount, WritableStakingInfoStore stakingInfoStore, WritableNetworkStakingRewardsStore stakingRewardStore, boolean containStakeMetaChanges, Instant consensusNow) {
        Long modifiedStakedNodeId;
        Long currentStakedNodeId;
        if (scenario.withdrawsFromNode() && (currentStakedNodeId = originalAccount.stakedNodeId()) != -1L) {
            this.stakeInfoHelper.withdrawStake(currentStakedNodeId, originalAccount, stakingInfoStore);
            if (containStakeMetaChanges) {
                long effectiveStakeRewardStart = this.rewardableStakeStartFor(stakingRewardStore.isStakingRewardsActivated(), originalAccount);
                this.stakeInfoHelper.increaseUnclaimedStakeRewards(currentStakedNodeId, effectiveStakeRewardStart, stakingInfoStore);
            }
        }
        if (scenario.awardsToNode() && !modifiedAccount.deleted() && (modifiedStakedNodeId = modifiedAccount.stakedNodeId()) != -1L) {
            this.stakeInfoHelper.awardStake(modifiedStakedNodeId, modifiedAccount, stakingInfoStore);
        }
    }

    public boolean shouldUpdateStakeAtStartOfLastRewardPeriod(@Nullable Account account, boolean isRewarded, long reward, @NonNull ReadableNetworkStakingRewardsStore stakingRewardStore, @NonNull Instant consensusNow) {
        if (account == null || account.stakedNodeIdOrElse(Long.valueOf(-1L)) == -1L || account.declineReward()) {
            return false;
        }
        if (!isRewarded) {
            return false;
        }
        if (reward > 0L) {
            return true;
        }
        if (this.earnedZeroRewardsBecauseOfZeroStake(account, stakingRewardStore, consensusNow)) {
            return true;
        }
        if (account.stakeAtStartOfLastRewardedPeriod() != -1L) {
            return false;
        }
        return account.stakePeriodStart() < this.stakePeriodManager.currentStakePeriod();
    }

    private long rewardableStakeStartFor(boolean rewardsActivated, @NonNull Account account) {
        long currentPeriod;
        if (!rewardsActivated || account.declineReward()) {
            return 0L;
        }
        long startPeriod = account.stakePeriodStart();
        if (startPeriod >= (currentPeriod = this.stakePeriodManager.currentStakePeriod())) {
            return 0L;
        }
        if (this.isRewardedSinceLastStakeMetaChange(account) && startPeriod == currentPeriod - 1L) {
            return account.stakeAtStartOfLastRewardedPeriod();
        }
        return StakingUtilities.roundedToHbar(StakingUtilities.totalStake(account));
    }

    private void decreaseStakeRewardAccountBalance(Map<AccountID, Long> rewardsPaid, AccountID stakingRewardAccountId, WritableAccountStore writableAccountStore) {
        if (!rewardsPaid.isEmpty()) {
            long totalPaidRewards = 0L;
            for (Long value : rewardsPaid.values()) {
                totalPaidRewards += value.longValue();
            }
            if (totalPaidRewards > 0L) {
                Account stakingRewardAccount = writableAccountStore.get(stakingRewardAccountId);
                long finalBalance = stakingRewardAccount.tinybarBalance() - totalPaidRewards;
                Account.Builder copy = stakingRewardAccount.copyBuilder();
                copy.tinybarBalance(finalBalance);
                writableAccountStore.put(copy.build());
            }
        }
    }

    private void updateStakedToMeFor(@Nullable AccountID stakeeId, long roundedFinalBalance, @NonNull WritableAccountStore writableStore) {
        if (stakeeId != null) {
            Account stakee = writableStore.get(stakeeId);
            if (stakee == null) {
                log.error("Stakee account {} not found in the store", (Object)stakeeId);
                return;
            }
            long initialStakedToMe = stakee.stakedToMe();
            long finalStakedToMe = initialStakedToMe + roundedFinalBalance;
            if (finalStakedToMe < 0L) {
                log.error("StakedToMe for account {} is negative after reward distribution, set it to 0", (Object)stakeeId);
            }
            Account copy = stakee.copyBuilder().stakedToMe(finalStakedToMe < 0L ? 0L : finalStakedToMe).build();
            writableStore.put(copy);
        }
    }
}

