/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

class IntSet {
    private final long[] data;
    private int size;

    IntSet(int sizeInBits) {
        this.data = new long[(sizeInBits + 63) / 64];
    }

    public int nextSetBit(int i) {
        int x = i / 64;
        if (x >= this.data.length) {
            return -1;
        }
        long w = this.data[x];
        if ((w >>>= i % 64) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.data.length) {
            if (this.data[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data[x]);
            }
            ++x;
        }
        return -1;
    }

    public void add(int i) {
        int n = i / 64;
        this.data[n] = this.data[n] | 1L << i % 64;
        ++this.size;
    }

    public void remove(int i) {
        int n = i / 64;
        this.data[n] = this.data[n] & (1L << i % 64 ^ 0xFFFFFFFFFFFFFFFFL);
        --this.size;
    }

    public int size() {
        return this.size;
    }
}

