/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.Registrations;

public interface Registration {
    public static Registration create(String path, HttpService ... services) {
        return new Registrations.ServicePathRegistration(path, services);
    }

    public static Registration create(HttpService ... services) {
        return new Registrations.ServiceRegistration(services);
    }

    public static Registration create(HttpRoute route) {
        return new Registrations.RouteRegistration(route);
    }

    public static Registration create(Filter filter) {
        return new Registrations.FilterRegistration(filter);
    }

    public static <T> Registration create(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
        return new Registrations.ErrorRegistration<T>(exceptionClass, handler);
    }

    public static Registration createMaxRerouteCount(int maxReRouteCount) {
        return new Registrations.MaxRerouteCountRegistration(maxReRouteCount);
    }

    public static Registration create(HttpSecurity security) {
        return new Registrations.SecurityRegistration(security);
    }

    public void register(HttpRouting.Builder var1);
}

