/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.history.ConstructionNodeId;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.ProofKeySet;
import com.hedera.hapi.node.state.history.RecordedHistorySignature;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.hapi.platform.state.StateKey;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class V059HistorySchema
extends Schema {
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().minor(59).build();
    private static final long MAX_PROOF_KEYS = 0x200000L;
    private static final long MAX_ASSEMBLY_SIGNATURES = 0x200000L;
    private static final long MAX_PROOF_VOTES = 0x200000L;
    public static final String LEDGER_ID_KEY = "LEDGER_ID";
    public static final int LEDGER_ID_STATE_ID = SingletonType.HISTORYSERVICE_I_LEDGER_ID.protoOrdinal();
    public static final String ACTIVE_PROOF_CONSTRUCTION_KEY = "ACTIVE_PROOF_CONSTRUCTION";
    public static final int ACTIVE_PROOF_CONSTRUCTION_STATE_ID = SingletonType.HISTORYSERVICE_I_ACTIVE_PROOF_CONSTRUCTION.protoOrdinal();
    public static final String NEXT_PROOF_CONSTRUCTION_KEY = "NEXT_PROOF_CONSTRUCTION";
    public static final int NEXT_PROOF_CONSTRUCTION_STATE_ID = SingletonType.HISTORYSERVICE_I_NEXT_PROOF_CONSTRUCTION.protoOrdinal();
    public static final String PROOF_KEY_SETS_KEY = "PROOF_KEY_SETS";
    public static final int PROOF_KEY_SETS_STATE_ID = StateKey.KeyOneOfType.HISTORYSERVICE_I_PROOF_KEY_SETS.protoOrdinal();
    public static final String HISTORY_SIGNATURES_KEY = "HISTORY_SIGNATURES";
    public static final int HISTORY_SIGNATURES_STATE_ID = StateKey.KeyOneOfType.HISTORYSERVICE_I_HISTORY_SIGNATURES.protoOrdinal();
    public static final String PROOF_VOTES_KEY = "PROOF_VOTES";
    public static final int PROOF_VOTES_STATE_ID = StateKey.KeyOneOfType.HISTORYSERVICE_I_PROOF_VOTES.protoOrdinal();
    private final Consumer<HistoryProof> proofConsumer;

    public V059HistorySchema(@NonNull Consumer<HistoryProof> proofConsumer) {
        super(VERSION);
        this.proofConsumer = Objects.requireNonNull(proofConsumer);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.singleton((int)LEDGER_ID_STATE_ID, (String)LEDGER_ID_KEY, (Codec)ProtoBytes.PROTOBUF), StateDefinition.singleton((int)ACTIVE_PROOF_CONSTRUCTION_STATE_ID, (String)ACTIVE_PROOF_CONSTRUCTION_KEY, (Codec)HistoryProofConstruction.PROTOBUF), StateDefinition.singleton((int)NEXT_PROOF_CONSTRUCTION_STATE_ID, (String)NEXT_PROOF_CONSTRUCTION_KEY, (Codec)HistoryProofConstruction.PROTOBUF), StateDefinition.onDisk((int)PROOF_KEY_SETS_STATE_ID, (String)PROOF_KEY_SETS_KEY, (Codec)NodeId.PROTOBUF, (Codec)ProofKeySet.PROTOBUF, (long)0x200000L), StateDefinition.onDisk((int)HISTORY_SIGNATURES_STATE_ID, (String)HISTORY_SIGNATURES_KEY, (Codec)ConstructionNodeId.PROTOBUF, (Codec)RecordedHistorySignature.PROTOBUF, (long)0x200000L), StateDefinition.onDisk((int)PROOF_VOTES_STATE_ID, (String)PROOF_VOTES_KEY, (Codec)ConstructionNodeId.PROTOBUF, (Codec)HistoryProofVote.PROTOBUF, (long)0x200000L));
    }

    public void migrate(@NonNull MigrationContext ctx) {
        WritableStates states = ctx.newStates();
        states.getSingleton(LEDGER_ID_STATE_ID).put((Object)ProtoBytes.DEFAULT);
        states.getSingleton(ACTIVE_PROOF_CONSTRUCTION_STATE_ID).put((Object)HistoryProofConstruction.DEFAULT);
        states.getSingleton(NEXT_PROOF_CONSTRUCTION_STATE_ID).put((Object)HistoryProofConstruction.DEFAULT);
    }

    public void restart(@NonNull MigrationContext ctx) {
        WritableStates states = ctx.newStates();
        HistoryProofConstruction activeConstruction = Objects.requireNonNull((HistoryProofConstruction)states.getSingleton(ACTIVE_PROOF_CONSTRUCTION_STATE_ID).get());
        if (activeConstruction.hasTargetProof()) {
            this.proofConsumer.accept(activeConstruction.targetProofOrThrow());
        }
    }
}

