/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.records.ContractOperationStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class SpecialRewardReceivers {
    public static final SpecialRewardReceivers SPECIAL_REWARD_RECEIVERS = new SpecialRewardReceivers();

    public void addInFrame(@NonNull MessageFrame frame, @NonNull CryptoTransferTransactionBody body, @NonNull List<AssessedCustomFee> assessedCustomFees) {
        ContractOperationStreamBuilder recordBuilder = FrameUtils.recordBuilderFor(frame);
        body.transfersOrElse(TransferList.DEFAULT).accountAmounts().forEach(adjustment -> recordBuilder.trackExplicitRewardSituation(adjustment.accountIDOrThrow()));
        body.tokenTransfers().forEach(transfers -> {
            transfers.transfers().forEach(adjustment -> recordBuilder.trackExplicitRewardSituation(adjustment.accountIDOrThrow()));
            transfers.nftTransfers().forEach(transfer -> {
                recordBuilder.trackExplicitRewardSituation(transfer.senderAccountIDOrThrow());
                recordBuilder.trackExplicitRewardSituation(transfer.receiverAccountIDOrThrow());
            });
        });
        assessedCustomFees.forEach(fee -> recordBuilder.trackExplicitRewardSituation(fee.feeCollectorAccountIdOrThrow()));
    }
}

