/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.BaseUInt256Value;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Quantity;

public final class Wei
extends BaseUInt256Value<Wei>
implements Quantity {
    public static final Wei ZERO = Wei.of(0L);
    public static final Wei ONE = Wei.of(1L);
    public static final Wei MAX_WEI = Wei.of(UInt256.MAX_VALUE);

    Wei(UInt256 value) {
        super(value, Wei::new);
    }

    private Wei(long v) {
        this(UInt256.valueOf((long)v));
    }

    private Wei(BigInteger v) {
        this(UInt256.valueOf((BigInteger)v));
    }

    private Wei(String hexString) {
        this(UInt256.fromHexString((String)hexString));
    }

    public static Wei of(long value) {
        return new Wei(value);
    }

    public static Wei of(BigInteger value) {
        return new Wei(value);
    }

    public static Wei of(UInt256 value) {
        return new Wei(value);
    }

    public static Wei ofNumber(Number value) {
        return new Wei((BigInteger)value);
    }

    public static Wei wrap(Bytes value) {
        return new Wei(UInt256.fromBytes((Bytes)value));
    }

    public static Wei fromHexString(String str) {
        return new Wei(str);
    }

    public static Wei fromEth(long eth) {
        return Wei.of(BigInteger.valueOf(eth).multiply(BigInteger.TEN.pow(18)));
    }

    @Override
    public Number getValue() {
        return this.getAsBigInteger();
    }

    @Override
    public BigInteger getAsBigInteger() {
        return this.toBigInteger();
    }

    @Override
    public String toHexString() {
        return super.toHexString();
    }

    @Override
    public String toShortHexString() {
        return super.isZero() ? "0x0" : super.toShortHexString();
    }

    public static Wei fromQuantity(Quantity quantity) {
        return Wei.wrap((Bytes)quantity);
    }

    public String toHumanReadableString() {
        BigInteger amount = this.toBigInteger();
        int numOfDigits = amount.toString().length();
        Unit preferredUnit = Unit.getPreferred(numOfDigits);
        double res = amount.doubleValue() / preferredUnit.divisor;
        return String.format("%1." + preferredUnit.decimals + "f %s", new Object[]{res, preferredUnit});
    }

    static enum Unit {
        Wei(0, 0),
        KWei(3),
        MWei(6),
        GWei(9),
        Szabo(12),
        Finney(15),
        Ether(18),
        KEther(21),
        MEther(24),
        GEther(27),
        TEther(30);

        final int pow;
        final double divisor;
        final int decimals;

        private Unit(int pow) {
            this(pow, 2);
        }

        private Unit(int pow, int decimals) {
            this.pow = pow;
            this.decimals = decimals;
            this.divisor = Math.pow(10.0, pow);
        }

        static Unit getPreferred(int numOfDigits) {
            return Arrays.stream(Unit.values()).filter(u -> numOfDigits <= u.pow + 3).findFirst().orElse(TEther);
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

