/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenCreateTransactionBody;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.FractionalFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TokenTupleUtils {
    private TokenTupleUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    @NonNull
    public static Tuple expiryTupleFor(@NonNull Token token) {
        return Tuple.of((Object)token.expirationSecond(), (Object)ConversionUtils.headlongAddressOf(token.autoRenewAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)), (Object)Math.max(0L, token.autoRenewSeconds()));
    }

    @NonNull
    public static Tuple expiryTupleFor(@NonNull TokenCreateTransactionBody token) {
        return Tuple.of((Object)token.expiry().seconds(), (Object)ConversionUtils.headlongAddressOf(token.autoRenewAccountOrElse(ReturnTypes.ZERO_ACCOUNT_ID)), (Object)Math.max(0L, token.autoRenewPeriodOrElse(Duration.DEFAULT).seconds()));
    }

    @NonNull
    public static Tuple feesTupleFor(int responseCode, @NonNull Token token) {
        List<? extends Tuple> fixedFees = TokenTupleUtils.fixedFeesTupleListFor(token);
        List<? extends Tuple> fractionalFees = TokenTupleUtils.fractionalFeesTupleListFor(token);
        List<? extends Tuple> royaltyFees = TokenTupleUtils.royaltyFeesTupleListFor(token);
        return Tuple.of((Object)responseCode, (Object)TokenTupleUtils.fixedFeesTupleListFor(token).toArray(new Tuple[fixedFees.size()]), (Object)TokenTupleUtils.fractionalFeesTupleListFor(token).toArray(new Tuple[fractionalFees.size()]), (Object)TokenTupleUtils.royaltyFeesTupleListFor(token).toArray(new Tuple[royaltyFees.size()]));
    }

    @NonNull
    private static List<? extends Tuple> fixedFeesTupleListFor(@NonNull Token token) {
        assert (token.customFees() != null);
        return token.customFees().stream().filter(CustomFee::hasFixedFee).map(fee -> Tuple.of((Object)fee.fixedFeeOrElse(FixedFee.DEFAULT).amount(), (Object)ConversionUtils.headlongAddressOf(fee.fixedFee().denominatingTokenIdOrElse(ReturnTypes.ZERO_TOKEN_ID)), (Object)(!fee.fixedFeeOrElse(FixedFee.DEFAULT).hasDenominatingTokenId() ? 1 : 0), (Object)false, (Object)ConversionUtils.headlongAddressOf(fee.feeCollectorAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)))).toList();
    }

    @NonNull
    private static List<? extends Tuple> fixedFeesTupleListFor(@NonNull TokenCreateTransactionBody token) {
        assert (token.customFees() != null);
        return token.customFees().stream().filter(CustomFee::hasFixedFee).map(fee -> Tuple.of((Object)fee.fixedFeeOrElse(FixedFee.DEFAULT).amount(), (Object)ConversionUtils.headlongAddressOf(fee.fixedFee().denominatingTokenIdOrElse(ReturnTypes.ZERO_TOKEN_ID)), (Object)(!fee.fixedFeeOrElse(FixedFee.DEFAULT).hasDenominatingTokenId() ? 1 : 0), (Object)false, (Object)ConversionUtils.headlongAddressOf(fee.feeCollectorAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)))).toList();
    }

    @NonNull
    private static List<? extends Tuple> fractionalFeesTupleListFor(@NonNull Token token) {
        return token.customFees().stream().filter(CustomFee::hasFractionalFee).map(fee -> Tuple.of((Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).fractionalAmountOrElse(ReturnTypes.ZERO_FRACTION).numerator(), (Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).fractionalAmountOrElse(ReturnTypes.ZERO_FRACTION).denominator(), (Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).minimumAmount(), (Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).maximumAmount(), (Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).netOfTransfers(), (Object)ConversionUtils.headlongAddressOf(fee.feeCollectorAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)))).toList();
    }

    @NonNull
    private static List<? extends Tuple> fractionalFeesTupleListFor(@NonNull TokenCreateTransactionBody token) {
        return token.customFees().stream().filter(CustomFee::hasFractionalFee).map(fee -> Tuple.of((Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).fractionalAmountOrElse(ReturnTypes.ZERO_FRACTION).numerator(), (Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).fractionalAmountOrElse(ReturnTypes.ZERO_FRACTION).denominator(), (Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).minimumAmount(), (Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).maximumAmount(), (Object)fee.fractionalFeeOrElse(FractionalFee.DEFAULT).netOfTransfers(), (Object)ConversionUtils.headlongAddressOf(fee.feeCollectorAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)))).toList();
    }

    @NonNull
    private static List<? extends Tuple> royaltyFeesTupleListFor(@NonNull Token token) {
        return token.customFees().stream().filter(CustomFee::hasRoyaltyFee).map(fee -> {
            boolean hasFallbackDenominatingTokenId = fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).fallbackFeeOrElse(ReturnTypes.ZERO_FIXED_FEE).hasDenominatingTokenId();
            TokenID denominatingTokenId = hasFallbackDenominatingTokenId ? fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).fallbackFee().denominatingTokenId() : ReturnTypes.ZERO_TOKEN_ID;
            return Tuple.of((Object)fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).exchangeValueFractionOrElse(ReturnTypes.ZERO_FRACTION).numerator(), (Object)fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).exchangeValueFractionOrElse(ReturnTypes.ZERO_FRACTION).denominator(), (Object)fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).fallbackFeeOrElse(ReturnTypes.ZERO_FIXED_FEE).amount(), (Object)ConversionUtils.headlongAddressOf(denominatingTokenId), (Object)(!hasFallbackDenominatingTokenId ? 1 : 0), (Object)ConversionUtils.headlongAddressOf(fee.feeCollectorAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)));
        }).toList();
    }

    @NonNull
    private static List<? extends Tuple> royaltyFeesTupleListFor(@NonNull TokenCreateTransactionBody token) {
        return token.customFees().stream().filter(CustomFee::hasRoyaltyFee).map(fee -> {
            boolean hasFallbackDenominatingTokenId = fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).fallbackFeeOrElse(ReturnTypes.ZERO_FIXED_FEE).hasDenominatingTokenId();
            TokenID denominatingTokenId = hasFallbackDenominatingTokenId ? fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).fallbackFee().denominatingTokenId() : ReturnTypes.ZERO_TOKEN_ID;
            return Tuple.of((Object)fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).exchangeValueFractionOrElse(ReturnTypes.ZERO_FRACTION).numerator(), (Object)fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).exchangeValueFractionOrElse(ReturnTypes.ZERO_FRACTION).denominator(), (Object)fee.royaltyFeeOrElse(RoyaltyFee.DEFAULT).fallbackFeeOrElse(ReturnTypes.ZERO_FIXED_FEE).amount(), (Object)ConversionUtils.headlongAddressOf(denominatingTokenId), (Object)(!hasFallbackDenominatingTokenId ? 1 : 0), (Object)ConversionUtils.headlongAddressOf(fee.feeCollectorAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)));
        }).toList();
    }

    @NonNull
    public static Tuple tokenInfoTupleFor(@NonNull Token token, @NonNull String ledgerId, int version) {
        List<? extends Tuple> fixedFees = TokenTupleUtils.fixedFeesTupleListFor(token);
        List<? extends Tuple> fractionalFees = TokenTupleUtils.fractionalFeesTupleListFor(token);
        List<? extends Tuple> royaltyFees = TokenTupleUtils.royaltyFeesTupleListFor(token);
        Tuple hederaToken = version == 1 ? TokenTupleUtils.hederaTokenTupleFor(token) : TokenTupleUtils.hederaTokenTupleFor16c(token);
        return Tuple.from((Object[])new Object[]{hederaToken, token.totalSupply(), token.deleted(), token.accountsKycGrantedByDefault(), token.paused(), fixedFees.toArray(new Tuple[fixedFees.size()]), fractionalFees.toArray(new Tuple[fractionalFees.size()]), royaltyFees.toArray(new Tuple[royaltyFees.size()]), ledgerId});
    }

    @NonNull
    public static Tuple tokenInfoTupleFor(@NonNull TokenCreateTransactionBody token, @NonNull String ledgerId, int version) {
        List<? extends Tuple> fixedFees = TokenTupleUtils.fixedFeesTupleListFor(token);
        List<? extends Tuple> fractionalFees = TokenTupleUtils.fractionalFeesTupleListFor(token);
        List<? extends Tuple> royaltyFees = TokenTupleUtils.royaltyFeesTupleListFor(token);
        Tuple hederaToken = version == 1 ? TokenTupleUtils.hederaTokenTupleFor(token) : TokenTupleUtils.hederaTokenTupleFor16c(token);
        return Tuple.from((Object[])new Object[]{hederaToken, token.initialSupply(), false, false, false, fixedFees.toArray(new Tuple[fixedFees.size()]), fractionalFees.toArray(new Tuple[fractionalFees.size()]), royaltyFees.toArray(new Tuple[royaltyFees.size()]), ledgerId});
    }

    @NonNull
    public static Tuple fungibleTokenInfoTupleFor(@NonNull Token token, @NonNull String ledgerId, int version) {
        return Tuple.of((Object)TokenTupleUtils.tokenInfoTupleFor(token, ledgerId, version), (Object)token.decimals());
    }

    @NonNull
    public static Tuple fungibleTokenInfoTupleFor(@NonNull TokenCreateTransactionBody token, @NonNull String ledgerId, int version) {
        return Tuple.of((Object)TokenTupleUtils.tokenInfoTupleFor(token, ledgerId, version), (Object)token.decimals());
    }

    @NonNull
    public static Tuple nftTokenInfoTupleFor(@NonNull Token token, @NonNull Nft nft, long serialNumber, @NonNull String ledgerId, @NonNull HederaNativeOperations nativeOperations, int version) {
        Objects.requireNonNull(nft);
        Objects.requireNonNull(token);
        Objects.requireNonNull(ledgerId);
        Objects.requireNonNull(nativeOperations);
        byte[] nftMetaData = nft.metadata() != null ? nft.metadata().toByteArray() : Bytes.EMPTY.toByteArray();
        return Tuple.of((Object)TokenTupleUtils.tokenInfoTupleFor(token, ledgerId, version), (Object)serialNumber, (Object)TokenTupleUtils.priorityAddressOf(nft.ownerIdOrElse(token.treasuryAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)), nativeOperations), (Object)nft.mintTimeOrElse(new Timestamp(0L, 0)).seconds(), (Object)nftMetaData, (Object)TokenTupleUtils.priorityAddressOf(nft.spenderIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID), nativeOperations));
    }

    @NonNull
    public static Tuple nftTokenInfoTupleFor(@NonNull TokenCreateTransactionBody token, @NonNull String ledgerId, int version) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(ledgerId);
        byte[] nftMetaData = token.metadata() != null ? token.metadata().toByteArray() : Bytes.EMPTY.toByteArray();
        return Tuple.of((Object)TokenTupleUtils.tokenInfoTupleFor(token, ledgerId, version), (Object)0L, (Object)ConversionUtils.headlongAddressOf(token.treasuryOrElse(ReturnTypes.ZERO_ACCOUNT_ID)), (Object)new Timestamp(0L, 0).seconds(), (Object)nftMetaData, (Object)ConversionUtils.headlongAddressOf(token.treasuryOrElse(ReturnTypes.ZERO_ACCOUNT_ID)));
    }

    private static Address priorityAddressOf(@NonNull AccountID accountId, @NonNull HederaNativeOperations nativeOperations) {
        Objects.requireNonNull(accountId);
        return ReturnTypes.ZERO_ACCOUNT_ID == accountId ? ReturnTypes.ZERO_ADDRESS : ConversionUtils.headlongAddressOf(Objects.requireNonNull(nativeOperations.getAccount(accountId)));
    }

    @NonNull
    public static Tuple typedKeyTupleFor(@NonNull BigInteger keyType, @NonNull Key key) {
        return Tuple.of((Object)keyType, (Object)Tuple.of((Object)false, (Object)ConversionUtils.headlongAddressOf(key.contractIDOrElse(ReturnTypes.ZERO_CONTRACT_ID)), (Object)key.ed25519OrElse(Bytes.EMPTY).toByteArray(), (Object)key.ecdsaSecp256k1OrElse(Bytes.EMPTY).toByteArray(), (Object)ConversionUtils.headlongAddressOf(key.delegatableContractIdOrElse(ReturnTypes.ZERO_CONTRACT_ID))));
    }

    @NonNull
    private static Tuple hederaTokenTupleFor(@NonNull Token token) {
        return Tuple.from((Object[])new Object[]{token.name(), token.symbol(), ConversionUtils.headlongAddressOf(token.treasuryAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)), token.memo(), token.supplyType().protoOrdinal() == 1, token.maxSupply(), token.accountsFrozenByDefault(), TokenTupleUtils.prepareKeyList(token, false), TokenTupleUtils.expiryTupleFor(token)});
    }

    @NonNull
    private static Tuple hederaTokenTupleFor(@NonNull TokenCreateTransactionBody token) {
        return Tuple.from((Object[])new Object[]{token.name(), token.symbol(), ConversionUtils.headlongAddressOf(token.treasuryOrElse(ReturnTypes.ZERO_ACCOUNT_ID)), token.memo(), token.supplyType().protoOrdinal() == 1, token.maxSupply(), token.freezeDefault(), TokenTupleUtils.prepareKeyList(token, false), TokenTupleUtils.expiryTupleFor(token)});
    }

    private static Tuple[] prepareKeyList(@NonNull Token token, boolean isV2) {
        ArrayList<Tuple> keyList = new ArrayList<Tuple>(List.of(TokenTupleUtils.typedKeyTupleFor(TokenKeyType.ADMIN_KEY.bigIntegerValue(), token.adminKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.KYC_KEY.bigIntegerValue(), token.kycKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.FREEZE_KEY.bigIntegerValue(), token.freezeKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.WIPE_KEY.bigIntegerValue(), token.wipeKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.SUPPLY_KEY.bigIntegerValue(), token.supplyKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.FEE_SCHEDULE_KEY.bigIntegerValue(), token.feeScheduleKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.PAUSE_KEY.bigIntegerValue(), token.pauseKeyOrElse(Key.DEFAULT))));
        if (isV2) {
            keyList.add(TokenTupleUtils.typedKeyTupleFor(TokenKeyType.METADATA_KEY.bigIntegerValue(), token.metadataKeyOrElse(Key.DEFAULT)));
        }
        return (Tuple[])keyList.toArray(Tuple[]::new);
    }

    private static Tuple[] prepareKeyList(@NonNull TokenCreateTransactionBody token, boolean isV2) {
        ArrayList<Tuple> keyList = new ArrayList<Tuple>(List.of(TokenTupleUtils.typedKeyTupleFor(TokenKeyType.ADMIN_KEY.bigIntegerValue(), token.adminKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.KYC_KEY.bigIntegerValue(), token.kycKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.FREEZE_KEY.bigIntegerValue(), token.freezeKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.WIPE_KEY.bigIntegerValue(), token.wipeKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.SUPPLY_KEY.bigIntegerValue(), token.supplyKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.FEE_SCHEDULE_KEY.bigIntegerValue(), token.feeScheduleKeyOrElse(Key.DEFAULT)), TokenTupleUtils.typedKeyTupleFor(TokenKeyType.PAUSE_KEY.bigIntegerValue(), token.pauseKeyOrElse(Key.DEFAULT))));
        if (isV2) {
            keyList.add(TokenTupleUtils.typedKeyTupleFor(TokenKeyType.METADATA_KEY.bigIntegerValue(), token.metadataKeyOrElse(Key.DEFAULT)));
        }
        return (Tuple[])keyList.toArray(Tuple[]::new);
    }

    @NonNull
    private static Tuple hederaTokenTupleFor16c(@NonNull Token token) {
        byte[] tokenMetaData = token.metadata().length() > 0L ? token.metadata().toByteArray() : Bytes.EMPTY.toByteArray();
        return Tuple.from((Object[])new Object[]{token.name(), token.symbol(), ConversionUtils.headlongAddressOf(token.treasuryAccountIdOrElse(ReturnTypes.ZERO_ACCOUNT_ID)), token.memo(), token.supplyType().protoOrdinal() == 1, token.maxSupply(), token.accountsFrozenByDefault(), TokenTupleUtils.prepareKeyList(token, true), TokenTupleUtils.expiryTupleFor(token), tokenMetaData});
    }

    @NonNull
    private static Tuple hederaTokenTupleFor16c(@NonNull TokenCreateTransactionBody token) {
        byte[] tokenMetaData = token.metadata().length() > 0L ? token.metadata().toByteArray() : Bytes.EMPTY.toByteArray();
        return Tuple.from((Object[])new Object[]{token.name(), token.symbol(), ConversionUtils.headlongAddressOf(token.treasuryOrElse(ReturnTypes.ZERO_ACCOUNT_ID)), token.memo(), token.supplyType().protoOrdinal() == 1, token.maxSupply(), token.freezeDefault(), TokenTupleUtils.prepareKeyList(token, true), TokenTupleUtils.expiryTupleFor(token), tokenMetaData});
    }

    public static enum TokenKeyType {
        ADMIN_KEY(1),
        KYC_KEY(2),
        FREEZE_KEY(4),
        WIPE_KEY(8),
        SUPPLY_KEY(16),
        FEE_SCHEDULE_KEY(32),
        PAUSE_KEY(64),
        METADATA_KEY(128);

        private final int value;

        private TokenKeyType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public BigInteger bigIntegerValue() {
            return BigInteger.valueOf(this.value);
        }
    }
}

