/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.hedera.node.app.service.contract.impl.hevm.OpsDurationSchedule;
import java.util.Objects;

public final class OpsDurationCounter {
    private static final OpsDurationCounter DISABLED = new OpsDurationCounter(OpsDurationSchedule.empty());
    private final OpsDurationSchedule schedule;
    private long opsDurationUnitsConsumed;

    public static OpsDurationCounter disabled() {
        return DISABLED;
    }

    public static OpsDurationCounter withSchedule(OpsDurationSchedule schedule) {
        return new OpsDurationCounter(schedule);
    }

    private OpsDurationCounter(OpsDurationSchedule schedule) {
        this.schedule = schedule;
        this.opsDurationUnitsConsumed = 0L;
    }

    public void recordOpsDurationUnitsConsumed(long opsDurationUnitsToConsume) {
        this.opsDurationUnitsConsumed += opsDurationUnitsToConsume;
    }

    public OpsDurationSchedule schedule() {
        return this.schedule;
    }

    public long opsDurationUnitsConsumed() {
        return this.opsDurationUnitsConsumed;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OpsDurationCounter)) {
            return false;
        }
        OpsDurationCounter that = (OpsDurationCounter)o;
        return this.opsDurationUnitsConsumed == that.opsDurationUnitsConsumed && Objects.equals(this.schedule, that.schedule);
    }

    public int hashCode() {
        return Objects.hash(this.schedule, this.opsDurationUnitsConsumed);
    }
}

