/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.CallCredentials;
import io.grpc.ClientInterceptor;
import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.webclient.grpc.GrpcClientMethodDescriptor;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

@Prototype.Blueprint
interface GrpcServiceDescriptorBlueprint {
    public String serviceName();

    @Option.Singular
    public Map<String, GrpcClientMethodDescriptor> methods();

    default public GrpcClientMethodDescriptor method(String name) {
        GrpcClientMethodDescriptor descriptor = this.methods().get(name);
        if (descriptor == null) {
            throw new NoSuchElementException("There is no method " + name + " defined for service " + String.valueOf(this));
        }
        return descriptor;
    }

    @Option.Singular
    public List<ClientInterceptor> interceptors();

    public Optional<CallCredentials> callCredentials();
}

