/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.schedulecall;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.schedulecall.ScheduleCallTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScheduleCallDecoder {
    @Inject
    public ScheduleCallDecoder() {
    }

    public TransactionBody decodeScheduleCall(@NonNull HssCallAttempt attempt, @NonNull Set<Key> keys) {
        boolean waitForExpiry;
        AccountID sender;
        Address to;
        Tuple call;
        int paramIndex = 0;
        if (attempt.isSelector(ScheduleCallTranslator.SCHEDULE_CALL)) {
            call = ScheduleCallTranslator.SCHEDULE_CALL.decodeCall(attempt.inputBytes());
            to = (Address)call.get(paramIndex++);
            sender = attempt.addressIdConverter().convertSender(attempt.senderAddress());
            waitForExpiry = true;
        } else if (attempt.isSelector(ScheduleCallTranslator.SCHEDULE_CALL_WITH_SENDER)) {
            call = ScheduleCallTranslator.SCHEDULE_CALL_WITH_SENDER.decodeCall(attempt.inputBytes());
            to = (Address)call.get(paramIndex++);
            sender = attempt.addressIdConverter().convert((Address)call.get(paramIndex++));
            waitForExpiry = true;
        } else if (attempt.isSelector(ScheduleCallTranslator.EXECUTE_CALL_ON_SENDER_SIGNATURE)) {
            call = ScheduleCallTranslator.EXECUTE_CALL_ON_SENDER_SIGNATURE.decodeCall(attempt.inputBytes());
            to = (Address)call.get(paramIndex++);
            sender = attempt.addressIdConverter().convert((Address)call.get(paramIndex++));
            waitForExpiry = false;
        } else {
            throw new IllegalStateException("Unexpected function selector");
        }
        BigInteger expirySecond = (BigInteger)call.get(paramIndex++);
        BigInteger gasLimit = (BigInteger)call.get(paramIndex++);
        BigInteger value = (BigInteger)call.get(paramIndex++);
        byte[] callData = (byte[])call.get(paramIndex);
        ContractID contractId = ConversionUtils.asContractId(attempt.enhancement().nativeOperations().entityIdFactory(), ConversionUtils.fromHeadlongAddress(to));
        return this.transactionBodyFor(attempt, this.scheduleCreateTransactionBodyFor(this.scheduledTransactionBodyFor(contractId, gasLimit, value, callData), keys, expirySecond, sender, waitForExpiry));
    }

    @VisibleForTesting
    public TransactionBody transactionBodyFor(@NonNull HssCallAttempt attempt, @NonNull ScheduleCreateTransactionBody scheduleCreateTrx) {
        return TransactionBody.newBuilder().transactionID(attempt.enhancement().nativeOperations().getTransactionID()).scheduleCreate(scheduleCreateTrx).build();
    }

    @VisibleForTesting
    public ScheduleCreateTransactionBody scheduleCreateTransactionBodyFor(@NonNull SchedulableTransactionBody scheduleTrx, @NonNull Set<Key> keys, @NonNull BigInteger expirySecond, @NonNull AccountID sender, boolean waitForExpiry) {
        Objects.requireNonNull(scheduleTrx);
        Objects.requireNonNull(keys);
        Objects.requireNonNull(expirySecond);
        Objects.requireNonNull(sender);
        return ScheduleCreateTransactionBody.newBuilder().scheduledTransactionBody(scheduleTrx).adminKey((Key)keys.stream().findFirst().orElse(null)).expirationTime(Timestamp.newBuilder().seconds(expirySecond.longValueExact())).payerAccountID(sender).waitForExpiry(waitForExpiry).build();
    }

    @VisibleForTesting
    public SchedulableTransactionBody scheduledTransactionBodyFor(@NonNull ContractID contractId, @NonNull BigInteger gasLimit, @NonNull BigInteger value, @NonNull byte[] callData) {
        Objects.requireNonNull(contractId);
        Objects.requireNonNull(gasLimit);
        Objects.requireNonNull(value);
        Objects.requireNonNull(callData);
        return SchedulableTransactionBody.newBuilder().contractCall(ContractCallTransactionBody.newBuilder().contractID(contractId).gas(gasLimit.longValueExact()).amount(value.longValueExact()).functionParameters(Bytes.wrap((byte[])callData))).build();
    }
}

