/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts;

import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.log.Log;
import org.hyperledger.besu.evm.log.LogTopic;

public class LogBuilder {
    private Address logger;
    private final List<Object> data = new ArrayList<Object>();
    private final List<LogTopic> topics = new ArrayList<LogTopic>();
    final StringBuilder tupleTypes = new StringBuilder("(");

    public static LogBuilder logBuilder() {
        return new LogBuilder();
    }

    public LogBuilder forLogger(Address logger) {
        this.logger = logger;
        return this;
    }

    public LogBuilder forEventSignature(Bytes eventSignature) {
        this.topics.add(LogBuilder.generateLogTopic(eventSignature));
        return this;
    }

    public LogBuilder forDataItem(Object dataItem) {
        this.data.add(this.convertDataItem(dataItem));
        LogBuilder.addTupleType(dataItem, this.tupleTypes);
        return this;
    }

    public LogBuilder forIndexedArgument(Object param) {
        this.topics.add(LogBuilder.generateLogTopic(param));
        return this;
    }

    public Log build() {
        if (this.tupleTypes.length() > 1) {
            this.tupleTypes.deleteCharAt(this.tupleTypes.length() - 1);
            this.tupleTypes.append(")");
            Tuple tuple = Tuple.from((Object[])this.data.toArray());
            TupleType tupleType = TupleType.parse((String)this.tupleTypes.toString());
            return new Log(this.logger, Bytes.wrap((byte[])tupleType.encode((Object)tuple).array()), this.topics);
        }
        return new Log(this.logger, Bytes.EMPTY, this.topics);
    }

    private Object convertDataItem(Object param) {
        if (param instanceof Address) {
            Address address = (Address)param;
            return LogBuilder.convertBesuAddressToHeadlongAddress(address);
        }
        if (param instanceof Long) {
            Long numeric = (Long)param;
            return BigInteger.valueOf(numeric);
        }
        return param;
    }

    private static LogTopic generateLogTopic(Object param) {
        byte[] array = new byte[]{};
        if (param instanceof Address) {
            Address address = (Address)param;
            array = address.toArray();
        } else if (param instanceof BigInteger) {
            BigInteger numeric = (BigInteger)param;
            array = numeric.toByteArray();
        } else if (param instanceof Long) {
            Long numeric = (Long)param;
            array = BigInteger.valueOf(numeric).toByteArray();
        } else if (param instanceof Boolean) {
            Boolean bool = (Boolean)param;
            array = new byte[]{(byte)(Boolean.TRUE.equals(bool) ? 1 : 0)};
        } else if (param instanceof Bytes) {
            Bytes bytes = (Bytes)param;
            array = bytes.toArray();
        }
        return LogTopic.wrap((Bytes)Bytes.wrap((byte[])LogBuilder.expandByteArrayTo32Length(array)));
    }

    private static void addTupleType(Object param, StringBuilder stringBuilder) {
        if (param instanceof Address) {
            stringBuilder.append("address,");
        } else if (param instanceof BigInteger || param instanceof Long) {
            stringBuilder.append("uint256,");
        } else if (param instanceof Boolean) {
            stringBuilder.append("bool,");
        }
    }

    private static byte[] expandByteArrayTo32Length(byte[] bytesToExpand) {
        byte[] expandedArray = new byte[32];
        System.arraycopy(bytesToExpand, 0, expandedArray, expandedArray.length - bytesToExpand.length, bytesToExpand.length);
        return expandedArray;
    }

    private static com.esaulpaugh.headlong.abi.Address convertBesuAddressToHeadlongAddress(@NonNull Address address) {
        return com.esaulpaugh.headlong.abi.Address.wrap((String)com.esaulpaugh.headlong.abi.Address.toChecksumAddress((BigInteger)address.toUnsignedBigInteger()));
    }
}

