/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.SystemContractOperations;
import com.hedera.node.app.service.contract.impl.state.HederaEvmAccount;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public interface HederaWorldUpdater
extends WorldUpdater {
    @NonNull
    public Enhancement enhancement();

    @Nullable
    public HederaEvmAccount getHederaAccount(@NonNull AccountID var1);

    @Nullable
    public HederaEvmAccount getHederaAccount(@NonNull ContractID var1);

    @Nullable
    default public HederaEvmAccount getHederaAccount(@NonNull Address address) {
        Objects.requireNonNull(address);
        Account maybeAccount = this.get(address);
        if (maybeAccount instanceof HederaEvmAccount) {
            HederaEvmAccount account = (HederaEvmAccount)maybeAccount;
            return account;
        }
        return null;
    }

    public ContractID getHederaContractId(@NonNull Address var1);

    @NonNull
    public Bytes entropy();

    public void collectGasFee(@NonNull AccountID var1, long var2, boolean var4);

    public void refundGasFee(@NonNull AccountID var1, long var2);

    public Optional<ExceptionalHaltReason> tryTransfer(@NonNull Address var1, @NonNull Address var2, long var3, boolean var5);

    public Optional<ExceptionalHaltReason> tryLazyCreation(@NonNull Address var1, @NonNull MessageFrame var2);

    public Optional<ExceptionalHaltReason> tryTrackingSelfDestructBeneficiary(@NonNull Address var1, @NonNull Address var2, MessageFrame var3);

    public void trackSelfDestructBeneficiary(@NonNull Address var1, @NonNull Address var2, MessageFrame var3);

    public Address setupTopLevelCreate(@NonNull ContractCreateTransactionBody var1);

    public void setupAliasedTopLevelCreate(@NonNull ContractCreateTransactionBody var1, @NonNull Address var2);

    public void setupTopLevelLazyCreate(@NonNull Address var1);

    public Address setupInternalCreate(@NonNull Address var1);

    public void setupInternalAliasedCreate(@NonNull Address var1, @NonNull Address var2);

    public boolean isHollowAccount(@NonNull Address var1);

    public void finalizeHollowAccount(@NonNull Address var1, @NonNull Address var2);

    @NonNull
    public TxStorageUsage getTxStorageUsage();

    @NonNull
    public ExchangeRate currentExchangeRate();

    public void setContractNotRequired();

    default public EntityIdFactory entityIdFactory() {
        return this.enhancement().nativeOperations().entityIdFactory();
    }

    public record Enhancement(@NonNull HederaOperations operations, @NonNull HederaNativeOperations nativeOperations, @NonNull SystemContractOperations systemOperations) {
        public Enhancement {
            Objects.requireNonNull(operations);
            Objects.requireNonNull(nativeOperations);
            Objects.requireNonNull(systemOperations);
        }
    }
}

