/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.collections.undo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hyperledger.besu.collections.undo.Undoable;

public class UndoScalar<T>
implements Undoable {
    T value;
    final List<UndoEntry<T>> undoLog = new ArrayList<UndoEntry<T>>();

    public static <T> UndoScalar<T> of(T value) {
        return new UndoScalar<T>(value);
    }

    public UndoScalar(T value) {
        this.value = value;
    }

    @Override
    public long lastUpdate() {
        return this.undoLog.isEmpty() ? 0L : this.undoLog.get((int)(this.undoLog.size() - 1)).level;
    }

    public boolean updated() {
        return !this.undoLog.isEmpty();
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        if (!Objects.equals(this.value, value)) {
            this.undoLog.add(new UndoEntry<T>(this.value));
            this.value = value;
        }
    }

    @Override
    public void undo(long mark) {
        if (this.undoLog.isEmpty()) {
            return;
        }
        for (int pos = this.undoLog.size() - 1; pos >= 0; --pos) {
            UndoEntry<T> entry = this.undoLog.get(pos);
            if (entry.level <= mark) {
                return;
            }
            this.value = entry.value;
            this.undoLog.remove(pos);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UndoScalar)) {
            return false;
        }
        UndoScalar that = (UndoScalar)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "UndoScalar{value=" + this.value + ", undoLog=" + this.undoLog + "}";
    }

    record UndoEntry<T>(T value, long level) {
        UndoEntry(T value) {
            this(value, Undoable.incrementMarkStatic());
        }
    }
}

