/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.contractvalidation;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.code.CodeInvalid;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EOFValidationCodeRule
implements ContractValidationRule {
    private static final Logger LOG = LoggerFactory.getLogger(EOFValidationCodeRule.class);
    final int maxEofVersion;
    final boolean inCreateTransaction;

    private EOFValidationCodeRule(int maxEofVersion, boolean inCreateTransaction) {
        this.maxEofVersion = maxEofVersion;
        this.inCreateTransaction = inCreateTransaction;
    }

    @Override
    public Optional<ExceptionalHaltReason> validate(Bytes contractCode, MessageFrame frame) {
        Code code = CodeFactory.createCode(contractCode, this.maxEofVersion, this.inCreateTransaction);
        if (!code.isValid()) {
            LOG.trace("EOF Validation Error: {}", (Object)((CodeInvalid)code).getInvalidReason());
            return Optional.of(ExceptionalHaltReason.INVALID_CODE);
        }
        if (frame.getCode().getEofVersion() > code.getEofVersion()) {
            LOG.trace("Cannot deploy older eof versions: initcode version - {} runtime code version - {}", (Object)frame.getCode().getEofVersion(), (Object)code.getEofVersion());
            return Optional.of(ExceptionalHaltReason.EOF_CREATE_VERSION_INCOMPATIBLE);
        }
        return Optional.empty();
    }

    public static ContractValidationRule of(int maxEofVersion, boolean inCreateTransaction) {
        return new EOFValidationCodeRule(maxEofVersion, inCreateTransaction);
    }
}

