/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.ethereum.rlp;

import java.util.function.Consumer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.ethereum.rlp.BytesValueRLPInput;
import org.hyperledger.besu.ethereum.rlp.BytesValueRLPOutput;
import org.hyperledger.besu.ethereum.rlp.RLPDecodingHelpers;
import org.hyperledger.besu.ethereum.rlp.RLPEncodingHelpers;
import org.hyperledger.besu.ethereum.rlp.RLPException;
import org.hyperledger.besu.ethereum.rlp.RLPInput;
import org.hyperledger.besu.ethereum.rlp.RLPOutput;

public abstract class RLP {
    public static final Bytes NULL = RLP.encodeOne(Bytes.EMPTY);
    public static final Bytes EMPTY_LIST;
    public static final int MAX_PREFIX_SIZE = 9;

    private RLP() {
    }

    public static RLPInput input(Bytes encoded) {
        return RLP.input(encoded, false);
    }

    public static RLPInput input(Bytes encoded, boolean lenient) {
        return new BytesValueRLPInput(encoded, lenient);
    }

    public static Bytes encode(Consumer<RLPOutput> writer) {
        BytesValueRLPOutput out = new BytesValueRLPOutput();
        writer.accept(out);
        return out.encoded();
    }

    public static Bytes encodeOne(Bytes value) {
        if (RLPEncodingHelpers.isSingleRLPByte(value)) {
            return value;
        }
        MutableBytes res = MutableBytes.create((int)RLPEncodingHelpers.elementSize(value));
        RLPEncodingHelpers.writeElement(value, res, 0);
        return res;
    }

    public static Bytes decodeOne(Bytes encodedValue) {
        int size;
        int offset;
        if (encodedValue.size() == 0) {
            throw new RLPException("Invalid empty input for RLP decoding");
        }
        int prefix = encodedValue.get(0) & 0xFF;
        RLPDecodingHelpers.Kind kind = RLPDecodingHelpers.Kind.of(prefix);
        if (kind.isList()) {
            throw new RLPException(String.format("Invalid input: value %s is an RLP list", encodedValue));
        }
        if (kind == RLPDecodingHelpers.Kind.BYTE_ELEMENT) {
            return encodedValue;
        }
        if (kind == RLPDecodingHelpers.Kind.SHORT_ELEMENT) {
            offset = 1;
            size = prefix - 128;
        } else {
            int sizeLength = prefix - 183;
            if (1 + sizeLength > encodedValue.size()) {
                throw new RLPException(String.format("Malformed RLP input: not enough bytes to read size of long item in %s: expected %d bytes but only %d", encodedValue, sizeLength + 1, encodedValue.size()));
            }
            offset = 1 + sizeLength;
            size = RLPDecodingHelpers.extractSize(index -> encodedValue.get(index), 1, sizeLength);
        }
        if (offset + size != encodedValue.size()) {
            throw new RLPException(String.format("Malformed RLP input: %s should be of size %d according to prefix byte but of size %d", encodedValue, offset + size, encodedValue.size()));
        }
        return encodedValue.slice(offset, size);
    }

    public static void validate(Bytes encodedValue) {
        RLPInput in = RLP.input(encodedValue);
        while (!in.isDone()) {
            if (in.nextIsList()) {
                in.enterList();
                continue;
            }
            if (in.isEndOfCurrentList()) {
                in.leaveList();
                continue;
            }
            in.skipNext();
        }
    }

    public static int calculateSize(Bytes value) {
        return RLPDecodingHelpers.rlpElementMetadata(index -> value.get((int)index), value.size(), 0L).getEncodedSize();
    }

    static {
        BytesValueRLPOutput out = new BytesValueRLPOutput();
        out.startList();
        out.endList();
        EMPTY_LIST = out.encoded();
    }
}

